package org.gcube.portlets.admin.invitessent.server;

import java.util.ArrayList;

import org.gcube.common.portal.PortalContext;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portal.databook.shared.ex.InviteIDNotFoundException;
import org.gcube.portal.databook.shared.ex.InviteStatusNotFoundException;
import org.gcube.portlets.admin.invitessent.client.InvitesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
*
* @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
*/
@SuppressWarnings("serial")
public class InvitesServiceImpl extends RemoteServiceServlet implements InvitesService {
	
	private static final Logger _log = LoggerFactory.getLogger(InvitesServiceImpl.class);
	

	private DatabookStore store;
	public void init() {
		store = new DBCassandraAstyanaxImpl();
	}
	public void destroy() {
		store.closeConnection();
	}
	
			
	@Override
	public ArrayList<Invite> getInvites(InviteStatus[] statuses) {
		PortalContext pContext = PortalContext.getConfiguration();
		String userName = pContext.getCurrentUser(getThreadLocalRequest()).getUsername();
		if (userName.compareTo("test.user") == 0) {
			_log.debug("Found " + userName + " returning nothing");
			return null;
		}
		String vreid = pContext.getCurrentScope(getThreadLocalRequest());
	
		ArrayList<Invite> toReturn = new ArrayList<Invite>();
		try {
			toReturn.addAll(store.getInvitedEmailsByVRE(vreid, statuses));
		} catch (InviteIDNotFoundException | InviteStatusNotFoundException e) {
			e.printStackTrace();
			return null;
		}
		return toReturn;
	}

  
}
