/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portets.user.message_conversations.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.ui.MaterialCollection;
import gwt.material.design.client.ui.MaterialCollectionItem;
import gwt.material.design.client.ui.MaterialDropDown;
import gwt.material.design.client.ui.MaterialIcon;
import gwt.material.design.client.ui.MaterialImage;
import gwt.material.design.client.ui.MaterialLabel;
import gwt.material.design.client.ui.MaterialLink;
import java.util.Date;
import org.gcube.portets.user.message_conversations.client.Utils;
import org.gcube.portets.user.message_conversations.client.ui.ApplicationView;
import org.gcube.portets.user.message_conversations.client.ui.MessageItem;
import org.gcube.portets.user.message_conversations.client.ui.resources.MessagesResources;
import org.gcube.portets.user.message_conversations.shared.ConvMessage;

public class MessageItem
extends Composite {
    private static MessageItemUiBinder uiBinder = (MessageItemUiBinder)GWT.create(MessageItemUiBinder.class);
    private static final Color HOVER_MESSAGE_COLOR = Color.GREY_LIGHTEN_4;
    private boolean deleteClicked = true;
    private ApplicationView ap;
    private MaterialCollection parentCollection;
    private ConvMessage myMessage;
    private boolean sent;
    @UiField
    MaterialCollectionItem item;
    @UiField
    MaterialImage avatarImage;
    @UiField
    MaterialLabel senderNameLabel;
    @UiField
    MaterialLabel subjectLabel;
    @UiField
    MaterialLabel previewLabel;
    @UiField
    MaterialLabel timeLabel;
    @UiField
    MaterialIcon attachmentsIcon;
    @UiField
    MaterialIcon messageActionIcon;
    @UiField
    MaterialLink setUnreadButton;
    @UiField
    MaterialLink deleteButton;
    @UiField
    MaterialDropDown dd;
    MessagesResources images = (MessagesResources)GWT.create(MessagesResources.class);

    public MessageItem(ConvMessage m, MaterialCollection parentCollection, ApplicationView ap, boolean sent) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.item.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.sent = sent;
        this.myMessage = m;
        this.ap = ap;
        this.parentCollection = parentCollection;
        if (m.hasAttachments()) {
            this.attachmentsIcon.setVisibility(Style.Visibility.VISIBLE);
        }
        if (!sent && !m.isRead()) {
            this.item.addStyleName("unread-message");
        }
        if (sent || !this.myMessage.isRead()) {
            this.dd.remove(0);
        }
        if (m.getOwner().getAvatarURL() == null || m.getOwner().getAvatarURL().compareTo("") == 0) {
            if (sent) {
                this.avatarImage.setResource(m.getRecipients().size() > 1 ? this.images.group() : this.images.user());
            } else {
                this.avatarImage.setResource(this.images.user());
            }
        } else if (sent && m.getRecipients().size() > 1) {
            this.avatarImage.setResource(this.images.group());
        } else {
            this.avatarImage.setUrl(m.getOwner().getAvatarURL());
        }
        String fullName = m.getOwner().getFullName() == null ? m.getOwner().getUsername() : m.getOwner().getFullName();
        this.senderNameLabel.setText(fullName);
        this.subjectLabel.setText(m.getSubject().length() > 40 ? m.getSubject().substring(0, 37) + " ..." : m.getSubject());
        this.previewLabel.setText(m.getContent());
        this.timeLabel.setText(Utils.getFormatteDate((Date)m.getDate()));
        if (sent) {
            this.item.setBackgroundColor(Color.WHITE);
        }
        if (!Utils.isMobile()) {
            this.item.addMouseOverHandler((MouseOverHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.item.addMouseOutHandler((MouseOutHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.messageActionIcon.setVisibility(Style.Visibility.VISIBLE);
            this.dd.setHoverable(false);
        }
        this.messageActionIcon.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.dd.getElement().getStyle().setWidth(300.0, Style.Unit.PX);
        String activator = "activate" + Random.nextInt();
        this.dd.setActivator(activator);
        this.messageActionIcon.setActivates(activator);
    }

    @UiHandler(value={"setUnreadButton"})
    void onSetUnread(ClickEvent e) {
        e.stopPropagation();
        if (this.myMessage.isRead()) {
            this.ap.setMessageUnread(this.myMessage, this.sent);
            this.myMessage.setRead(false);
            this.item.addStyleName("unread-message");
        } else {
            Window.alert((String)"Message is marked as unread already.");
        }
    }

    private void doDelete(String subject) {
        if (this.deleteClicked) {
            this.ap.deleteMessage(this.myMessage, this.sent);
        } else {
            this.deleteClicked = true;
        }
    }

    public void setSelected(boolean active) {
        this.item.setBackgroundColor(Color.WHITE);
        this.item.removeStyleName("unread-message");
        this.item.setActive(active);
        this.myMessage.setRead(true);
    }

    @UiHandler(value={"item"})
    void onClickedMessage(ClickEvent e) {
        this.checkHideSideBarOnMobile();
        this.parentCollection.clearActive();
        this.ap.readUserMessage(this.myMessage.getId(), this.sent);
        this.setSelected(true);
        this.myMessage.setRead(true);
    }

    private void checkHideSideBarOnMobile() {
        if (Utils.isMobile()) {
            this.ap.hideSidePanel();
        }
    }

    public void hideMessageMenu() {
        this.messageActionIcon.setVisible(false);
    }

    static /* synthetic */ Color access$000() {
        return HOVER_MESSAGE_COLOR;
    }

    static /* synthetic */ boolean access$102(MessageItem x0, boolean x1) {
        x0.deleteClicked = x1;
        return x0.deleteClicked;
    }

    static /* synthetic */ void access$200(MessageItem x0, String x1) {
        x0.doDelete(x1);
    }
}

