/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portets.user.message_conversations.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasRows;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.constants.Position;
import gwt.material.design.client.ui.MaterialAnchorButton;
import gwt.material.design.client.ui.MaterialBadge;
import gwt.material.design.client.ui.MaterialCollection;
import gwt.material.design.client.ui.MaterialFAB;
import gwt.material.design.client.ui.MaterialLink;
import gwt.material.design.client.ui.MaterialProgress;
import gwt.material.design.client.ui.MaterialRow;
import gwt.material.design.client.ui.animate.MaterialAnimation;
import gwt.material.design.client.ui.animate.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.portets.user.message_conversations.client.MessageService;
import org.gcube.portets.user.message_conversations.client.MessageServiceAsync;
import org.gcube.portets.user.message_conversations.client.Utils;
import org.gcube.portets.user.message_conversations.client.ui.ApplicationView;
import org.gcube.portets.user.message_conversations.client.ui.DisplayMessage;
import org.gcube.portets.user.message_conversations.client.ui.MessageItem;
import org.gcube.portets.user.message_conversations.client.ui.MyMaterialCollection;
import org.gcube.portets.user.message_conversations.client.ui.ShowMorePagerPanel;
import org.gcube.portets.user.message_conversations.client.ui.WriteMessage;
import org.gcube.portets.user.message_conversations.client.ui.resources.MessagesResources;
import org.gcube.portets.user.message_conversations.shared.ConvMessage;
import org.gcube.portets.user.message_conversations.shared.MessageUserModel;

public class ApplicationView
extends Composite {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private final MessageServiceAsync convService = (MessageServiceAsync)GWT.create(MessageService.class);
    protected static boolean WRITING_MESSAGE = false;
    private boolean toggle = false;
    private boolean toggleSwitch = false;
    private int unreadMessages = 0;
    private int totalMessages = 0;
    @UiField
    ScrollPanel scrollerPanel;
    @UiField
    MaterialRow rightPanel;
    @UiField
    HTMLPanel htmlPanel;
    @UiField
    MaterialFAB FAB;
    @UiField
    MaterialLink menu;
    @UiField
    MaterialLink newMessage;
    @UiField
    MaterialLink switcher;
    @UiField
    MaterialAnchorButton replyAll;
    @UiField
    MaterialAnchorButton reply;
    @UiField
    MaterialAnchorButton forward;
    @UiField
    MaterialProgress messageLoader;
    @UiField
    MaterialProgress messagesLoader;
    @UiField
    MaterialBadge badge;
    @UiField
    ShowMorePagerPanel pagerPanel;
    MyMaterialCollection<ConvMessage> messagesCollection;
    private ConvMessage currentSelected;
    private DisplayMessage displayMessage;
    private WriteMessage newMessageDisplay;
    private boolean isSendTo = false;

    public ApplicationView(String ... sendToUserNames) {
        String[] usernamesToSendTo;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        ((ServiceDefTarget)this.convService).setServiceEntryPoint(Utils.getServiceEntryPoint());
        this.displayMessage = new DisplayMessage(this.convService, this);
        this.newMessageDisplay = new WriteMessage(this.convService, this);
        Window.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.scrollerPanel.add((Widget)this.displayMessage);
        if (!Utils.isMobile()) {
            this.reply.setTooltip("Reply");
            this.reply.setTooltipPosition(Position.LEFT);
            this.replyAll.setTooltip("Reply All");
            this.replyAll.setTooltipPosition(Position.LEFT);
            this.forward.setTooltip("Forward");
            this.forward.setTooltipPosition(Position.LEFT);
        }
        if ((usernamesToSendTo = sendToUserNames) != null && usernamesToSendTo.length > 0) {
            this.prepareNewMessageForSendTo(usernamesToSendTo);
            this.isSendTo = true;
            this.messageLoader.setVisible(false);
        }
        this.readUserMessages(false, this.isSendTo);
    }

    public void readUserMessages(boolean sent, boolean isSendTo) {
        this.messagesLoader.setVisible(true);
        this.convService.getMessages(sent, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showErrorOccurred() {
        this.messagesLoader.setVisible(false);
        this.messageLoader.setVisible(false);
        this.hideSidePanel();
        this.writeErrorMessage();
    }

    public void showMessages(ArrayList<ConvMessage> messages, boolean sent) {
        this.messagesLoader.setVisible(false);
        int scrollerHeight = Window.getClientHeight() - 100;
        this.scrollerPanel.setHeight(scrollerHeight + "px");
        this.pagerPanel.setHeight(scrollerHeight + "px");
        GWT.log((String)("message returned are " + messages.size()));
        this.messagesCollection = new MyMaterialCollection(messages, c -> new MessageItem(c, (MaterialCollection)this.messagesCollection, this, sent));
        this.messagesCollection.init();
        this.pagerPanel.setDisplay((HasRows)this.messagesCollection);
        for (ConvMessage convMessage : messages) {
            if (!sent && !convMessage.isRead()) {
                ++this.unreadMessages;
            }
            ++this.totalMessages;
        }
        if (messages.size() > 0) {
            GWT.log((String)("message returned are " + messages.size()));
            MessageItem first = (MessageItem)this.messagesCollection.getChildrenList().get(0);
            first.setSelected(true);
        }
        this.updateBadge(sent);
    }

    public void deleteMessage(ConvMessage toDelete, boolean sent) {
        this.convService.deleteMessageById(toDelete.getId(), sent, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setMessageUnread(ConvMessage toSet, boolean sent) {
        this.convService.markMessageUnread(toSet.getId(), sent, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void readUserMessage(String messageId, boolean sent) {
        if (WRITING_MESSAGE) {
            boolean continueDisplay = Window.confirm((String)"The message content you are writing will be lost if you continue");
            if (continueDisplay) {
                this.displayMessage(messageId, sent);
            }
        } else {
            this.displayMessage(messageId, sent);
        }
    }

    private void displayMessage(String messageId, boolean sent) {
        this.messageLoader.setVisible(true);
        this.scrollerPanel.clear();
        this.convService.getMessageById(messageId, this.toggleSwitch, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateBadge(boolean sent) {
        String badgeText = this.totalMessages + (sent ? " sent" : " (" + this.unreadMessages + " unread)");
        if (this.unreadMessages == 0 && !sent) {
            badgeText = this.totalMessages + " received";
        }
        this.badge.setText(badgeText);
        this.badge.setVisible(true);
    }

    private void decreaseUnreadCounter(ConvMessage toShow) {
        if (this.unreadMessages > 0 && !toShow.isRead()) {
            --this.unreadMessages;
        }
        this.updateBadge(false);
    }

    private void resetCounters() {
        this.badge.setVisible(false);
        this.unreadMessages = 0;
        this.totalMessages = 0;
    }

    @UiHandler(value={"switcher"})
    void onSwitchSentInbox(ClickEvent e) {
        this.resetCounters();
        MaterialAnimation animation = new MaterialAnimation();
        animation.setDelay(0);
        animation.setDuration(1000);
        animation.transition(Transition.FLIPINX);
        animation.animate((Widget)this.switcher);
        if (!this.toggleSwitch) {
            this.switcher.setIconType(IconType.SEND);
        } else {
            this.switcher.setIconType(IconType.INBOX);
        }
        this.toggleSwitch = !this.toggleSwitch;
        this.readUserMessages(this.toggleSwitch, false);
    }

    @UiHandler(value={"menu"})
    void onHideShowSidebar(ClickEvent e) {
        if (this.toggle) {
            this.showSidePanel();
        } else {
            this.hideSidePanel();
        }
    }

    private void displayNewOrReplyMessage() {
        WRITING_MESSAGE = true;
        this.FAB.setVisible(false);
        this.messagesCollection.clearActive();
        this.scrollerPanel.clear();
        this.scrollerPanel.add((Widget)this.newMessageDisplay);
        this.newMessageDisplay.setFocusOnUsersInput();
        if (Utils.isMobile()) {
            this.hideSidePanel();
        }
    }

    private void prepareNewMessageForSendTo(String[] usernamesToSendTo) {
        this.newMessageDisplay = new WriteMessage(this.convService, this);
        this.newMessageDisplay.setNewMessageForSendTo(usernamesToSendTo);
        this.displayNewOrReplyMessage();
    }

    @UiHandler(value={"newMessage"})
    void onNewMessage(ClickEvent e) {
        this.newMessageDisplay = new WriteMessage(this.convService, this);
        this.displayNewOrReplyMessage();
    }

    @UiHandler(value={"reply"})
    void onReplyMessage(ClickEvent e) {
        if (this.currentSelected != null) {
            this.newMessageDisplay = new WriteMessage(this.convService, this);
            ConvMessage msg = this.currentSelected;
            this.newMessageDisplay.setIsReply(msg);
            this.displayNewOrReplyMessage();
        } else {
            Window.alert((String)"Cannot find which message to reply, please report the issue");
        }
    }

    @UiHandler(value={"replyAll"})
    void onReplyAllMessage(ClickEvent e) {
        if (this.currentSelected != null) {
            this.newMessageDisplay = new WriteMessage(this.convService, this);
            ConvMessage msg = this.currentSelected;
            this.newMessageDisplay.setIsReplyAll(msg);
            this.displayNewOrReplyMessage();
        } else {
            Window.alert((String)"Cannot find which message to reply all, please report the issue");
        }
    }

    @UiHandler(value={"forward"})
    void onForwardMessage(ClickEvent e) {
        if (this.currentSelected != null) {
            this.newMessageDisplay = new WriteMessage(this.convService, this);
            ConvMessage msg = this.currentSelected;
            this.newMessageDisplay.setIsForward(msg);
            this.displayNewOrReplyMessage();
        } else {
            Window.alert((String)"Cannot find which message to forward, please report the issue");
        }
    }

    protected void showSidePanel() {
        this.displayMessage.getMainPanel().setLeft(350.0);
        this.displayMessage.getMainPanel().setGrid("l8 m12 s12");
        this.newMessageDisplay.getMainPanel().setLeft(350.0);
        this.newMessageDisplay.getMainPanel().setGrid("l8 m12 s12");
        this.rightPanel.setLeft(0.0);
        this.toggle = !this.toggle;
    }

    protected void hideSidePanel() {
        this.displayMessage.getMainPanel().setLeft(0.0);
        this.displayMessage.getMainPanel().setGrid("l12 s12 m12");
        this.newMessageDisplay.getMainPanel().setLeft(0.0);
        this.newMessageDisplay.getMainPanel().setGrid("l12 s12 m12");
        this.rightPanel.setLeft(-350.0);
        this.toggle = !this.toggle;
    }

    private void setCurrentSelectedMessage(ConvMessage msg) {
        this.currentSelected = msg;
    }

    private void writeWelcomeMessage() {
        MessagesResources images = (MessagesResources)GWT.create(MessagesResources.class);
        List<MessageUserModel> recipients = Arrays.asList(new MessageUserModel(0L, "you", "You", ""));
        MessageUserModel sender = new MessageUserModel(0L, "jarvis", "D4Science Team", images.d4scienceTeam().getURL(), "", "");
        ConvMessage welcomeMessage = new ConvMessage("0", "Welcome to your Messages", sender, recipients, new Date(), "Welcome to your Messages.\nMessages lets you stay connected, organized, and productive at work, at home, and everywhere in between. Also, you can easily attach very large files to your messages from Workspace.\n\nThis message will automatically be deleted as soon you'll receive another one.", true, false);
        this.FAB.setVisible(false);
        this.displayMessage.showMessage(welcomeMessage);
        welcomeMessage.setContent("Welcome to your Messages.\nMessages lets you stay connected, organized, and productive at work, at home, and everywhere in between. Also, you can easily attach very large files to your messages from Workspace.\n\nThis message will automatically be deleted as soon you'll receive another one.".substring(0, 102) + " ...");
        MessageItem item = new MessageItem(welcomeMessage, (MaterialCollection)this.messagesCollection, this, false);
        item.hideMessageMenu();
        this.messagesCollection.add((Widget)item);
        ++this.totalMessages;
        this.updateBadge(false);
    }

    private void writeErrorMessage() {
        MessagesResources images = (MessagesResources)GWT.create(MessagesResources.class);
        List<MessageUserModel> recipients = Arrays.asList(new MessageUserModel(0L, "you", "You", ""));
        MessageUserModel sender = new MessageUserModel(0L, "jarvis", "D4Science Team", images.d4scienceTeam().getURL(), "", "");
        ConvMessage welcomeMessage = new ConvMessage("0", "An error occurred!", sender, recipients, new Date(), "We are very sorry, it is impossible to read your messages at the moment.\n\nThis could be either a networking problem or an error on the server. Please try to reload this page, if the error persists report the issue.", true, false);
        this.FAB.setVisible(false);
        this.displayMessage.showMessage(welcomeMessage);
        welcomeMessage.setContent("We are very sorry, it is impossible to read your messages at the moment.\n\nThis could be either a networking problem or an error on the server. Please try to reload this page, if the error persists report the issue.".substring(0, 102) + " ...");
        MessageItem item = new MessageItem(welcomeMessage, (MaterialCollection)this.messagesCollection, this, false);
        item.hideMessageMenu();
        this.messagesCollection.add((Widget)item);
        ++this.totalMessages;
        this.updateBadge(false);
    }

    static /* synthetic */ void access$000(ApplicationView x0) {
        x0.writeWelcomeMessage();
    }

    static /* synthetic */ void access$100(ApplicationView x0) {
        x0.showErrorOccurred();
    }

    static /* synthetic */ int access$202(ApplicationView x0, int x1) {
        x0.totalMessages = x1;
        return x0.totalMessages;
    }

    static /* synthetic */ int access$200(ApplicationView x0) {
        return x0.totalMessages;
    }

    static /* synthetic */ void access$300(ApplicationView x0, boolean x1) {
        x0.updateBadge(x1);
    }

    static /* synthetic */ int access$408(ApplicationView x0) {
        return x0.unreadMessages++;
    }

    static /* synthetic */ DisplayMessage access$500(ApplicationView x0) {
        return x0.displayMessage;
    }

    static /* synthetic */ void access$600(ApplicationView x0, ConvMessage x1) {
        x0.setCurrentSelectedMessage(x1);
    }

    static /* synthetic */ void access$700(ApplicationView x0, ConvMessage x1) {
        x0.decreaseUnreadCounter(x1);
    }
}

