/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portets.user.message_conversations.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.portets.user.message_conversations.client.MessageService;
import org.gcube.portets.user.message_conversations.shared.ConvMessage;
import org.gcube.portets.user.message_conversations.shared.CurrUserAndPortalUsersWrapper;
import org.gcube.portets.user.message_conversations.shared.FileModel;
import org.gcube.portets.user.message_conversations.shared.MessageUserModel;
import org.gcube.portets.user.message_conversations.shared.WSUser;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvServiceImpl
extends RemoteServiceServlet
implements MessageService {
    private static final Logger _log = LoggerFactory.getLogger(ConvServiceImpl.class);
    private PortalContext pContext;
    private UserManager um;

    public void init() {
        this.um = new LiferayUserManager();
        this.pContext = PortalContext.getConfiguration();
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    private GCubeUser getCurrentUser(HttpServletRequest httpServletRequest) {
        if (this.isWithinPortal()) {
            try {
                long userId = PortalUtil.getUser((HttpServletRequest)httpServletRequest).getUserId();
                long groupId = this.pContext.getCurrentGroupId(httpServletRequest);
                if (GroupLocalServiceUtil.hasUserGroup((long)userId, (long)groupId)) {
                    return this.um.getUserById(userId);
                }
                _log.error("User not authorised in Group, the logged user id=" + userId + " does not belong to group " + groupId);
                return null;
            }
            catch (Exception e) {
                _log.warn("Could not read user from LR PortalUtil in delegate servlet");
                return null;
            }
        }
        return this.pContext.getCurrentUser(this.getThreadLocalRequest());
    }

    public ArrayList<ConvMessage> getMessages(boolean sent) {
        ArrayList<ConvMessage> toReturn = new ArrayList<ConvMessage>();
        try {
            GCubeUser user = this.getCurrentUser(this.getThreadLocalRequest());
            this.pContext = PortalContext.getConfiguration();
            _log.debug("*** Reading user = " + user.getFullname());
            String scope = this.pContext.getCurrentScope(this.getThreadLocalRequest());
            ScopeProvider.instance.set(scope);
            String token = this.pContext.getCurrentUserToken(scope, user.getUserId());
            SecurityTokenProvider.instance.set(token);
            Workspace workspace = null;
            try {
                HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
                HomeManager manager = factory.getHomeManager();
                workspace = manager.getHome().getWorkspace();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            List listMessages = null;
            List list = listMessages = sent ? workspace.getWorkspaceMessageManager().getSentMessages() : workspace.getWorkspaceMessageManager().getReceivedMessages();
            if (listMessages == null) {
                _log.error("listMessages is null, Could not read messages of " + user.getFullname());
                return null;
            }
            _log.debug("Got messages of " + user.getFullname() + " how many? " + listMessages.size());
            Collections.reverse(listMessages);
            LiferayUserManager um = new LiferayUserManager();
            for (WorkspaceMessage m : listMessages) {
                boolean hasAttachments;
                String previewBody = m.getBody().length() > 80 ? m.getBody().substring(0, 79) + " ..." : m.getBody();
                MessageUserModel mu = null;
                GCubeUser sender = null;
                try {
                    if (sent) {
                        if (m.getAddresses().size() < 2) {
                            GCubeUser recipient = um.getUserByUsername((String)m.getAddresses().get(0));
                            mu = new MessageUserModel(recipient.getUserId(), recipient.getUsername(), recipient.getFullname(), recipient.getUserAvatarURL(), "", "");
                        } else {
                            GCubeUser recipient1 = um.getUserByUsername((String)m.getAddresses().get(0));
                            GCubeUser recipient2 = um.getUserByUsername((String)m.getAddresses().get(1));
                            String label2Display = recipient1.getFirstName() + " & " + recipient2.getFirstName();
                            if (m.getAddresses().size() > 2) {
                                label2Display = label2Display + " & ...";
                            }
                            mu = new MessageUserModel(recipient1.getUserId(), recipient1.getUsername(), label2Display, null, "", "");
                        }
                    } else {
                        sender = um.getUserByUsername(m.getSender().getPortalLogin());
                        mu = new MessageUserModel(sender.getUserId(), sender.getUsername(), sender.getFullname(), sender.getUserAvatarURL(), "", "");
                    }
                }
                catch (Exception ex) {
                    mu = !sent ? new MessageUserModel(m.getSender().getPortalLogin()) : new MessageUserModel((String)m.getAddresses().get(0));
                }
                boolean bl = hasAttachments = !m.getAttachmentsIds().isEmpty();
                if (!sent) {
                    toReturn.add(new ConvMessage(m.getId(), m.getSubject(), mu, new Date(m.getSendTime().getTimeInMillis()), previewBody, m.isRead(), hasAttachments));
                    continue;
                }
                ArrayList<MessageUserModel> recipients = new ArrayList<MessageUserModel>();
                for (String rec : m.getAddresses()) {
                    recipients.add(new MessageUserModel(rec));
                }
                toReturn.add(new ConvMessage(m.getId(), m.getSubject(), mu, recipients, new Date(m.getSendTime().getTimeInMillis()), previewBody, m.isRead(), hasAttachments));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        _log.trace("get All Messages Received ");
        return toReturn;
    }

    public boolean markMessageUnread(String messageId, boolean sent) {
        GCubeUser user = this.getCurrentUser(this.getThreadLocalRequest());
        String scope = this.pContext.getCurrentScope(this.getThreadLocalRequest());
        SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
        try {
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            HomeManager manager = factory.getHomeManager();
            Workspace workspace = manager.getHome().getWorkspace();
            WorkspaceMessage m = sent ? workspace.getWorkspaceMessageManager().getSentMessage(messageId) : workspace.getWorkspaceMessageManager().getReceivedMessage(messageId);
            m.setStatus(false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ConvMessage getMessageById(String messageId, boolean sent) {
        ConvMessage toReturn = null;
        try {
            GCubeUser user = this.getCurrentUser(this.getThreadLocalRequest());
            _log.debug("*** Reading user from liferay session = " + user.getFullname());
            String scope = this.pContext.getCurrentScope(this.getThreadLocalRequest());
            SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
            LiferayUserManager um = new LiferayUserManager();
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            HomeManager manager = factory.getHomeManager();
            Workspace workspace = manager.getHome().getWorkspace();
            WorkspaceMessage m = sent ? workspace.getWorkspaceMessageManager().getSentMessage(messageId) : workspace.getWorkspaceMessageManager().getReceivedMessage(messageId);
            MessageUserModel mu = null;
            GCubeUser sender = null;
            try {
                sender = um.getUserByUsername(m.getSender().getPortalLogin());
                mu = new MessageUserModel(sender.getUserId(), sender.getUsername(), sender.getFullname(), this.extractDomainFromEmail(sender.getEmail()));
            }
            catch (Exception ex) {
                mu = new MessageUserModel(m.getSender().getPortalLogin());
            }
            ArrayList<MessageUserModel> recipients = new ArrayList<MessageUserModel>();
            for (String recipient : m.getAddresses()) {
                try {
                    GCubeUser toAdd = um.getUserByUsername(recipient);
                    recipients.add(new MessageUserModel(toAdd.getUserId(), toAdd.getUsername(), toAdd.getFullname(), this.extractDomainFromEmail(toAdd.getEmail())));
                }
                catch (Exception ex) {
                    recipients.add(new MessageUserModel(recipient));
                }
            }
            ArrayList<FileModel> attachments = new ArrayList<FileModel>();
            List attachItems = m.getAttachmentsIds();
            for (String itemId : attachItems) {
                WorkspaceItem item = workspace.getItem(itemId);
                String downloadURL = null;
                attachments.add(new FileModel(item.getId(), item.getName(), null, item.isFolder(), downloadURL));
            }
            boolean hasAttachments = !attachItems.isEmpty();
            toReturn = new ConvMessage(m.getId(), m.getSubject(), mu, recipients, new Date(m.getSendTime().getTimeInMillis()), m.getBody(), m.isRead(), attachments, hasAttachments);
            if (!sent) {
                m.setStatus(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public String getAttachmentDownloadURL(String itemId) {
        GCubeUser user = this.getCurrentUser(this.getThreadLocalRequest());
        String scope = this.pContext.getCurrentScope(this.getThreadLocalRequest());
        SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
        _log.info("getAttachmentDownloadURL for user " + user.getUsername() + " file id=" + itemId);
        try {
            StorageHubClient shc = new StorageHubClient();
            String downladURL = shc.open(itemId).asFile().getPublicLink().toString();
            downladURL = downladURL.startsWith("https") ? downladURL : downladURL.replace("http", "https");
            return downladURL;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveAttachmentToWorkspaceFolder(String itemId, String destinationFolderId) {
        GCubeUser user = this.getCurrentUser(this.getThreadLocalRequest());
        String scope = this.pContext.getCurrentScope(this.getThreadLocalRequest());
        SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
        try {
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            HomeManager manager = factory.getHomeManager();
            Workspace workspace = manager.getHome().getWorkspace();
            WorkspaceItem copied = workspace.copy(itemId, destinationFolderId);
            return copied != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteMessageById(String messageId, boolean sent) {
        GCubeUser user = this.getCurrentUser(this.getThreadLocalRequest());
        _log.debug("deleteMessageById reading user from liferay session = " + user.getFullname() + " m id = " + messageId);
        String scope = this.pContext.getCurrentScope(this.getThreadLocalRequest());
        SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
        try {
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            HomeManager manager = factory.getHomeManager();
            WorkspaceMessageManager workspaceMessanger = manager.getHome().getWorkspace().getWorkspaceMessageManager();
            if (sent) {
                workspaceMessanger.deleteSentMessage(messageId);
            } else {
                workspaceMessanger.deleteReceivedMessage(messageId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public ArrayList<WSUser> searchUsers(String keyword) {
        ArrayList<WSUser> toReturn = new ArrayList<WSUser>();
        if (this.isWithinPortal()) {
            long gatewayGroupId = this.pContext.getCurrentGroupId(this.getThreadLocalRequest());
            try {
                _log.debug("Searching " + keyword);
                List users = this.um.searchUsersByGroup(keyword, gatewayGroupId);
                for (GCubeUser user : users) {
                    toReturn.add(new WSUser("" + user.getUserId(), user.getUsername(), user.getFullname(), this.extractDomainFromEmail(user.getEmail())));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                toReturn.add(new WSUser("andrea.rossi", "andrea.rossi", "Andrea Rossi", "m.assante@gmail.com"));
                if (i % 2 == 0) {
                    toReturn.add(new WSUser("" + i, "username" + i, "userGetFullname()" + i, "user.getEmail()" + i));
                    continue;
                }
                toReturn.add(new WSUser("" + i, "ciccio" + i, "ciccioNome" + i, "ciccioEMail" + i));
            }
        }
        return toReturn;
    }

    public ArrayList<WSUser> getUsersInfo(String[] usernames) {
        ArrayList<WSUser> toReturn = new ArrayList<WSUser>();
        if (this.isWithinPortal()) {
            try {
                for (String username : usernames) {
                    User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
                    toReturn.add(new WSUser("" + user.getUserId(), user.getScreenName(), user.getFullName(), this.extractDomainFromEmail(user.getEmailAddress())));
                }
            }
            catch (PortalException | SystemException e) {
                e.printStackTrace();
            }
        } else {
            toReturn.add(new WSUser("andrea.rossi", "andrea.rossi", "Andrea Rossi", "rossi@gmail.com"));
            toReturn.add(new WSUser("ginoi", "gino", "Gino Pino", "gino@hotmail.com"));
        }
        return toReturn;
    }

    public boolean sendToById(ArrayList<String> recipientIds, ArrayList<String> listAttachmentsId, String subject, String body) {
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currentUser = pContext.getCurrentUser(this.getThreadLocalRequest());
        if (listAttachmentsId == null) {
            listAttachmentsId = new ArrayList();
        }
        try {
            Workspace workspace = HomeLibrary.getUserWorkspace((String)currentUser.getUsername());
            _log.info("Sending message to: " + recipientIds.toString());
            String checkedSubject = subject;
            String checkedBody = body;
            String messageId = workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(checkedSubject, checkedBody, listAttachmentsId, recipientIds);
            try {
                body = body + this.getPublicLinksForAttachs(workspace, listAttachmentsId);
            }
            catch (InternalErrorException | ItemNotFoundException e) {
                _log.error("Ops, could not generate publick link for some of the attachments");
            }
            _log.debug("Sending message notification to: " + recipientIds.toString());
            List recipients = this.getUsersbyUserId(recipientIds);
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), pContext.getCurrentScope(this.getThreadLocalRequest()), new SocialNetworkingUser(currentUser.getUsername(), currentUser.getEmail(), currentUser.getFullname(), currentUser.getUserAvatarURL()));
            Thread thread = new Thread((Runnable)new MessageNotificationsThread(recipients, messageId, checkedSubject, body, (NotificationsManager)nm));
            thread.start();
            return messageId != null;
        }
        catch (Exception e) {
            _log.error("While Sending message to: " + recipientIds.toString());
            e.printStackTrace();
            return false;
        }
    }

    private String extractDomainFromEmail(String email) {
        int index = email.indexOf(64);
        if (index > 0) {
            return email.substring(index);
        }
        return "@unknown-domain";
    }

    private List<GenericItemBean> getUsersbyUserId(List<String> recipientIds) {
        ArrayList<GenericItemBean> recipients = new ArrayList<GenericItemBean>();
        for (String userid : recipientIds) {
            GCubeUser user = null;
            try {
                user = new LiferayUserManager().getUserByUsername(userid);
                recipients.add(new GenericItemBean("" + user.getUserId(), user.getUsername(), user.getFullname(), ""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recipients;
    }

    private String getPublicLinksForAttachs(Workspace workspace, ArrayList<String> listAttachmentsId) throws ItemNotFoundException, InternalErrorException {
        if (listAttachmentsId != null && !listAttachmentsId.isEmpty()) {
            ArrayList<WorkspaceItem> attachments = new ArrayList<WorkspaceItem>();
            for (String itemId : listAttachmentsId) {
                attachments.add(workspace.getItem(itemId));
            }
            StringBuilder builder = new StringBuilder();
            if (attachments != null && attachments.size() > 0) {
                builder.append("\n\n\nThe following ");
                String msg = attachments.size() > 1 ? "files were attached to this message:" : "file was attached to this message:";
                builder.append(msg + "\n");
                for (WorkspaceItem workspaceItem : attachments) {
                    if (!workspaceItem.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) continue;
                    FolderItem folderItem = (FolderItem)workspaceItem;
                    String publicLink = "";
                    String itemName = "";
                    try {
                        itemName = workspaceItem.getName();
                        publicLink = folderItem.getPublicLink(true);
                    }
                    catch (InternalErrorException e) {
                        _log.warn("An error occurred when creating public link for attachment, skipping file: " + itemName);
                        return "";
                    }
                    builder.append(itemName + " (" + publicLink + ")");
                    builder.append("\n");
                }
                _log.debug("returning public links: " + builder.toString());
                return builder.toString();
            }
            return "";
        }
        return "";
    }

    public CurrUserAndPortalUsersWrapper getWorkspaceUsers() {
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currentUser = pContext.getCurrentUser(this.getThreadLocalRequest());
        _log.debug("trying to get WorkspaceUsers ..");
        WSUser currUser = null;
        ArrayList<WSUser> portalUsers = new ArrayList<WSUser>();
        try {
            if (this.isWithinPortal()) {
                LiferayUserManager um = new LiferayUserManager();
                LiferayGroupManager gm = new LiferayGroupManager();
                List users = um.listUsersByGroup(gm.getRootVO().getGroupId());
                for (GCubeUser user : users) {
                    _log.trace("Trying to get additional info for " + user.getUsername());
                    portalUsers.add(new WSUser(user.getUserId() + "", user.getUsername(), user.getFullname(), user.getEmail()));
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    portalUsers.add(new WSUser("" + i, "username" + i, "userGetFullname()" + i, "user.getEmail()" + i));
                }
            }
            currUser = new WSUser(currentUser.getUsername(), currentUser.getUsername(), currentUser.getFullname(), currentUser.getEmail());
        }
        catch (Exception e) {
            _log.error("Error in server get all contacts ", (Throwable)e);
        }
        CurrUserAndPortalUsersWrapper toReturn = new CurrUserAndPortalUsersWrapper(currUser, portalUsers);
        return toReturn;
    }
}

