/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.management;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationState;
import org.gcube.portlets.user.warmanagementwidget.server.accesslog.AccessLogUtil;
import org.gcube.portlets.user.warmanagementwidget.server.util.Util;


/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class GCubeWarDeleter implements Runnable {

	protected Logger logger = Logger.getLogger(GCubeWarDeleter.class);

	protected OperationProgress operationProgress;

	protected String user;
	protected String warId;
	protected GCUBEScope scope;
	protected GCUBESecurityManager securityManager;

	public GCubeWarDeleter(OperationProgress operationProgress,
			String user, GCUBEScope scope, GCUBESecurityManager securityManager, 
			String warId) {
		this.operationProgress = operationProgress;
		this.user = user;
		this.warId = warId;
		this.scope = scope;
		this.securityManager = securityManager;

		ConsoleAppender ca = new ConsoleAppender(new SimpleLayout());
		ca.setThreshold(Level.ALL);
		ca.activateOptions();
		logger.addAppender(ca);
		logger.setLevel(Level.ALL);
	}

	@Override
	public void run() {

		operationProgress.setElaboratedLenght(0);
		
		logger.trace("retrieving IS Publisher");
		ISPublisher publisher;
		try {
			publisher = GHNContext.getImplementation(ISPublisher.class);
		} catch (Exception e) {
			logger.error("An error occured retrieving the ISPublisher", e);
			operationProgress.setFailed("An error occured retrieving the Software Repository instance", Util.exceptionDetailMessage(e));
			return;
		}
		
		operationProgress.setElaboratedLenght(1);
		logger.trace("deleting the SA profile");
		try {
			publisher.removeGCUBEResource(warId, GCUBEService.TYPE, scope, securityManager);
		} catch (Exception e) {
			logger.error("An error occured deleting the SA profile", e);
			operationProgress.setFailed("An error occured removing the SA", Util.exceptionDetailMessage(e));
			return;
		}
		
		operationProgress.setState(OperationState.COMPLETED);
		AccessLogUtil.logWarRemoved(user, scope, warId);

		/*logger.trace("retrieving Software Repository Service in scope "+scope);
		SoftwareRepositoryPortType sr;
		try {
			sr = ISUtil.getSoftwareRepositoryPortType(securityManager, scope);
		} catch (Exception e) {
			logger.error("An error occured retrieving the SR epr", e);
			operationProgress.setFailed("An error occured retrieving the SR epr: "+e.getMessage());
			return;
		}

		operationProgress.setElaboratedLenght(1);
		logger.trace("deleting the SA on the SR");
		String deleteResult;
		try {
			deleteResult = sr.delete(warId);
		} catch (Exception e) {
			logger.error("An error occured deleting the SA", e);
			operationProgress.setFailed("An error occured deleting the SA: "+e.getMessage());
			return;
		}

		logger.trace("delete result: "+deleteResult);
		
		if ("OK".equals(deleteResult)) operationProgress.setState(OperationState.COMPLETED);
		else operationProgress.setFailed(deleteResult);*/
	}
	
}
