/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal;

import java.io.IOException;
import java.security.Key;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.ldapexport.LDAPSync;
import org.gcube.portal.socialmail.PeriodicTask;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalSchedulerService
extends HttpServlet {
    private static final Logger _log = LoggerFactory.getLogger(PortalSchedulerService.class);
    private static final int POP3_MINUTES_DELAY = 1;
    private static final int LDAP_MINUTES_DELAY = 10;
    private static DatabookStore store;
    private static String portalName;
    private static String host;
    private static String user;
    private static String password;

    public void init() {
        store = new DBCassandraAstyanaxImpl();
        portalName = PortalContext.getPortalInstanceName();
        PortalContext context = PortalContext.getConfiguration();
        String scope = "/" + context.getInfrastructureName();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
        query.addCondition("$resource/Profile/Name/text() eq '" + portalName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List list = client.submit((Query)query);
        if (list == null || list.isEmpty()) {
            _log.error("Could not find any Service endpoint registred in the infrastructure for this portal: " + portalName);
        } else if (list.size() > 1) {
            _log.warn("Found more than one Service endpoint registred in the infrastructure for this portal: " + portalName);
        } else {
            for (ServiceEndpoint res : list) {
                ServiceEndpoint.AccessPoint found = (ServiceEndpoint.AccessPoint)res.profile().accessPoints().iterator().next();
                host = found.address();
                user = found.username();
                String encrPassword = found.password();
                try {
                    password = StringEncrypter.getEncrypter().decrypt(encrPassword, new Key[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ScheduledExecutorService ldapScheduler = Executors.newScheduledThreadPool(1);
        ldapScheduler.scheduleAtFixedRate((Runnable)new LDAPSync(), 0L, 10L, TimeUnit.MINUTES);
        ScheduledExecutorService pop3Scheduler = Executors.newScheduledThreadPool(1);
        pop3Scheduler.scheduleAtFixedRate((Runnable)new PeriodicTask(store, portalName, host, user, password), 0L, 1L, TimeUnit.MINUTES);
        String toReturn = "<DIV>Check Notification Email Started ... </DIV>";
        toReturn = toReturn + "<DIV>LDAPSync SCRIPT Started ... </DIV>";
        response.setContentType("text/html");
        response.getWriter().write(toReturn);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

