/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.server;

import jakarta.mail.internet.AddressException;
import java.util.List;
import java.util.Map;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteOperationResult;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.databook.shared.RangeFeeds;
import org.gcube.portal.databook.shared.RangePosts;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.CommentIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.InviteIDNotFoundException;
import org.gcube.portal.databook.shared.ex.InviteStatusNotFoundException;
import org.gcube.portal.databook.shared.ex.LikeIDNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationChannelTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationIDNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;

public interface DatabookStore {
    public boolean requestFriendship(String var1, String var2);

    public boolean approveFriendship(String var1, String var2);

    public boolean denyFriendship(String var1, String var2);

    public List<String> getFriends(String var1);

    public List<String> getPendingFriendRequests(String var1);

    public boolean saveUserFeed(Feed var1);

    public boolean saveUserPost(Post var1);

    public boolean saveUserFeed(Feed var1, List<Attachment> var2);

    public boolean saveUserPost(Post var1, List<Attachment> var2);

    public boolean deleteFeed(String var1) throws FeedIDNotFoundException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException;

    public boolean deletePost(String var1) throws FeedIDNotFoundException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException;

    public boolean saveFeedToVRETimeline(String var1, String var2) throws FeedIDNotFoundException;

    public boolean savePostToVRETimeline(String var1, String var2) throws FeedIDNotFoundException;

    public boolean saveAppFeed(Feed var1);

    public boolean saveAppPost(Post var1);

    public boolean saveAppFeed(Feed var1, List<Attachment> var2);

    public boolean saveAppPost(Post var1, List<Attachment> var2);

    public Feed readFeed(String var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public Post readPost(String var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public List<Feed> getAllFeedsByUser(String var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public List<Post> getAllPostsByUser(String var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public List<Feed> getAllFeedsByApp(String var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public List<Post> getAllPostsByApp(String var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public List<Feed> getRecentCommentedFeedsByUserAndDate(String var1, long var2) throws Exception;

    public List<Post> getRecentCommentedPostsByUserAndDate(String var1, long var2) throws Exception;

    public List<Feed> getAllPortalPrivacyLevelFeeds() throws FeedTypeNotFoundException, ColumnNameNotFoundException, PrivacyLevelTypeNotFoundException;

    public List<Post> getAllPortalPrivacyLevelPosts() throws FeedTypeNotFoundException, ColumnNameNotFoundException, PrivacyLevelTypeNotFoundException;

    public List<Feed> getRecentFeedsByUser(String var1, int var2) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException;

    public List<Post> getRecentPostsByUser(String var1, int var2) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException;

    public List<Feed> getAllFeedsByVRE(String var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException;

    public List<Post> getAllPostsByVRE(String var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException;

    public List<Feed> getRecentFeedsByVRE(String var1, int var2) throws IllegalArgumentException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException;

    public List<Post> getRecentPostsByVRE(String var1, int var2) throws IllegalArgumentException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException;

    public RangeFeeds getRecentFeedsByVREAndRange(String var1, int var2, int var3) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException;

    public RangePosts getRecentPostsByVREAndRange(String var1, int var2, int var3) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException;

    public List<Feed> getRecentFeedsByUserAndDate(String var1, long var2) throws IllegalArgumentException;

    public List<Post> getRecentPostsByUserAndDate(String var1, long var2) throws IllegalArgumentException;

    public boolean saveNotification(Notification var1);

    public boolean setNotificationRead(String var1) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException;

    public Notification readNotification(String var1) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException;

    public List<Notification> getAllNotificationByUser(String var1, int var2) throws NotificationTypeNotFoundException, ColumnNameNotFoundException, NotificationIDNotFoundException;

    public List<Notification> getRangeNotificationsByUser(String var1, int var2, int var3) throws NotificationTypeNotFoundException, ColumnNameNotFoundException, NotificationIDNotFoundException;

    public boolean setAllNotificationReadByUser(String var1) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException;

    public List<Notification> getUnreadNotificationsByUser(String var1) throws NotificationTypeNotFoundException, ColumnNameNotFoundException, NotificationIDNotFoundException;

    public boolean checkUnreadNotifications(String var1) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException;

    public boolean checkUnreadMessagesNotifications(String var1) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException;

    public List<NotificationChannelType> getUserNotificationChannels(String var1, NotificationType var2) throws NotificationChannelTypeNotFoundException, NotificationTypeNotFoundException;

    public boolean setUserNotificationPreferences(String var1, Map<NotificationType, NotificationChannelType[]> var2);

    public Map<NotificationType, NotificationChannelType[]> getUserNotificationPreferences(String var1) throws NotificationTypeNotFoundException, NotificationChannelTypeNotFoundException;

    public Comment readCommentById(String var1) throws CommentIDNotFoundException;

    public boolean addComment(Comment var1) throws FeedIDNotFoundException;

    public List<Comment> getAllCommentByFeed(String var1);

    public List<Comment> getAllCommentByPost(String var1);

    public List<Comment> getRecentCommentsByUserAndDate(String var1, long var2) throws Exception;

    public boolean editComment(Comment var1) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, CommentIDNotFoundException, FeedIDNotFoundException;

    public boolean deleteComment(String var1, String var2) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, CommentIDNotFoundException, FeedIDNotFoundException;

    public boolean like(Like var1) throws FeedIDNotFoundException;

    public boolean unlike(String var1, String var2, String var3) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, LikeIDNotFoundException, FeedIDNotFoundException;

    public List<String> getAllLikedFeedIdsByUser(String var1);

    public List<String> getAllLikedPostIdsByUser(String var1);

    public List<Feed> getAllLikedFeedsByUser(String var1, int var2) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public List<Post> getAllLikedPostsByUser(String var1, int var2) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public List<Feed> getRecentLikedFeedsByUserAndDate(String var1, long var2) throws IllegalArgumentException;

    public List<Post> getRecentLikedPostsByUserAndDate(String var1, long var2) throws IllegalArgumentException;

    public List<Like> getAllLikesByFeed(String var1);

    public List<Like> getAllLikesByPost(String var1);

    public boolean saveHashTags(String var1, String var2, List<String> var3) throws FeedIDNotFoundException;

    public boolean saveHashTagsComment(String var1, String var2, List<String> var3) throws CommentIDNotFoundException;

    public boolean deleteHashTags(String var1, String var2, List<String> var3) throws FeedIDNotFoundException;

    public boolean deleteHashTagsComment(String var1, String var2, List<String> var3) throws CommentIDNotFoundException;

    public Map<String, Integer> getVREHashtagsWithOccurrence(String var1);

    public Map<String, Integer> getVREHashtagsWithOccurrenceFilteredByTime(String var1, long var2);

    public List<Feed> getVREFeedsByHashtag(String var1, String var2) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public List<Post> getVREPostsByHashtag(String var1, String var2) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException;

    public InviteOperationResult saveInvite(Invite var1) throws AddressException;

    public String isExistingInvite(String var1, String var2);

    public Invite readInvite(String var1) throws InviteIDNotFoundException, InviteStatusNotFoundException;

    public boolean setInviteStatus(String var1, String var2, InviteStatus var3) throws InviteIDNotFoundException, InviteStatusNotFoundException;

    public List<Invite> getInvitedEmailsByVRE(String var1, InviteStatus ... var2) throws InviteIDNotFoundException, InviteStatusNotFoundException;

    public List<Attachment> getAttachmentsByFeedId(String var1) throws FeedIDNotFoundException;

    public List<String> getAllVREIds();

    public void closeConnection();
}

