/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalService;
import com.liferay.portal.service.UserGroupRoleLocalServiceWrapper;
import java.util.List;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.client.dsl.Util;
import org.gcube.common.storagehub.client.dsl.VREFolderManager;
import org.gcube.portal.plugins.util.AuthUtil;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeHookSiteRoleLocalService
extends UserGroupRoleLocalServiceWrapper {
    private static final Logger _log = LoggerFactory.getLogger(GCubeHookSiteRoleLocalService.class);
    private GroupManager gm = new LiferayGroupManager();

    public GCubeHookSiteRoleLocalService(UserGroupRoleLocalService userGroupRoleLocalService) {
        super(userGroupRoleLocalService);
        System.out.println("GCubeHookSiteRoleLocalService hook is UP & Listening ...");
    }

    public List<UserGroupRole> addUserGroupRoles(long userId, long groupId, long[] roleIds) throws SystemException {
        List toReturn = super.addUserGroupRoles(userId, groupId, roleIds);
        try {
            _log.debug("Check if addUserGroupRoles is done in a VRE");
            if (this.gm.isVRE(groupId).booleanValue()) {
                _log.debug("addUserGroupRoles performed in a VRE, groupId=" + groupId);
                boolean vreManagerRolePresent = false;
                for (int i = 0; i < roleIds.length; ++i) {
                    Role role = RoleLocalServiceUtil.getRole((long)roleIds[i]);
                    if (role.getName().compareTo("VRE-Manager") != 0) continue;
                    _log.info("User is being promoted (or was) as VREFolder Administrator, userId=" + userId + " on Site groupId=" + groupId);
                    vreManagerRolePresent = true;
                    break;
                }
                this.setVREFolderAdministrator(userId, groupId, vreManagerRolePresent);
            } else {
                _log.debug("addUserGroupRoles NOT done in a VRE, groupId=" + groupId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private void setVREFolderAdministrator(long userId, long groupId, boolean enable) throws Exception {
        String previousToken = SecurityTokenProvider.instance.get();
        String previousUMAToken = AccessTokenProvider.instance.get();
        try {
            AuthUtil.setInfraManagerLegacyAndUMATokenInThreadLocal();
            String context = this.gm.getInfrastructureScope(groupId);
            String vreFolderTitle = Util.getVREGroupFromContext((String)context);
            _log.debug("The vreFolderTitle on which the VREFolder role is being {} is {}", (Object)enable, (Object)vreFolderTitle);
            StorageHubClient shc = new StorageHubClient();
            VREFolderManager vreFolderManager = shc.getVreFolderManager(vreFolderTitle);
            String theUserToPromoteOrDeclass = new LiferayUserManager().getUserById(userId).getUsername();
            _log.info("The {} is being promoted? {} ", (Object)theUserToPromoteOrDeclass, (Object)enable);
            if (enable) {
                vreFolderManager.setAdmin(theUserToPromoteOrDeclass);
            } else {
                vreFolderManager.removeAdmin(theUserToPromoteOrDeclass);
            }
            _log.info("*VREFolder-Hook** add/remove role operation complete");
        }
        catch (Exception e) {
            _log.error("An error occurred (or the user was already Admin) when trying to update shub role of userId " + userId + " to the groupId: " + groupId, (Throwable)e);
            throw e;
        }
        finally {
            AccessTokenProvider.instance.set(previousUMAToken);
            SecurityTokenProvider.instance.set(previousToken);
        }
    }
}

