/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;

public class AuthUtil {
    private static Log _log = LogFactoryUtil.getLog(AuthUtil.class);

    public static void setInfraManagerLegacyAndUMATokenInThreadLocal() throws Exception {
        _log.info((Object)("Getting super user with role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName()));
        String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
        long rootgroupId = new LiferayGroupManager().getGroupIdFromInfrastructureScope(infraContext);
        User theAdmin = LiferayUserManager.getRandomUserWithRole((long)rootgroupId, (GatewayRolesNames)GatewayRolesNames.INFRASTRUCTURE_MANAGER);
        if (theAdmin == null) {
            _log.error((Object)("Cannot add the user to the VRE Folder: there is no user having role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER + " on context: " + infraContext));
        }
        String adminUsername = theAdmin.getScreenName();
        _log.info((Object)("Got the super user: " + adminUsername));
        String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
        ArrayList<String> rolesString = new ArrayList<String>();
        List theAdminRoles = new LiferayRoleManager().listRolesByUserAndGroup(theAdmin.getUserId(), rootgroupId);
        for (GCubeRole gCubeRole : theAdminRoles) {
            rolesString.add(gCubeRole.getRoleName());
        }
        rolesString.add(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
        _log.debug((Object)"legacy authorizationService().setTokenRoles done");
        Constants.authorizationService().setTokenRoles(theAdminToken, rolesString);
        SecurityTokenProvider.instance.set(theAdminToken);
        OIDCUmaUtil.provideConfiguredPortalClientUMATokenInThreadLocal((String)("/" + PortalContext.getConfiguration().getInfrastructureName()));
        _log.debug((Object)"new authorizationService PortalClient set UMA-Token done");
    }
}

