/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portal.service.UserLocalServiceWrapper;
import java.util.List;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.portal.plugins.thread.CheckShareLatexUserThread;
import org.gcube.portal.plugins.thread.RemoveUserTokenFromVREThread;
import org.gcube.portal.plugins.util.AuthUtil;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class GCubeHookUserLocalService
extends UserLocalServiceWrapper {
    private static Log _log = LogFactoryUtil.getLog(GCubeHookUserLocalService.class);

    public GCubeHookUserLocalService(UserLocalService userLocalService) {
        super(userLocalService);
        System.out.println("GCubeHookUserLocalService hook is UP & Listening ...");
    }

    public void addGroupUser(long groupId, long userId) throws SystemException {
        super.addGroupUser(groupId, userId);
        this.addUserToVRERelatedServices(groupId, userId);
    }

    public void addGroupUser(long groupId, User user) throws SystemException {
        super.addGroupUser(groupId, user.getUserId());
        this.addUserToVRERelatedServices(groupId, user.getUserId());
    }

    public void addGroupUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        super.addGroupUsers(groupId, userIds);
        this.addUsersToVRERelatedServices(groupId, userIds);
    }

    public void addGroupUsers(long groupId, List<User> Users) throws PortalException, SystemException {
        super.addGroupUsers(groupId, Users);
        for (User user : Users) {
            this.addUserToVRERelatedServices(groupId, user.getUserId());
        }
    }

    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException, SystemException {
        super.unsetGroupUsers(groupId, userIds, serviceContext);
        this.removeUsersFromVRERelatedServices(groupId, userIds);
    }

    public void deleteGroupUser(long groupId, long userId) throws SystemException {
        super.deleteGroupUser(groupId, userId);
        this.removeUserFromVREReleatedServices(groupId, userId);
    }

    public void deleteGroupUser(long groupId, User user) throws SystemException {
        super.deleteGroupUser(groupId, user);
        this.removeUserFromVREReleatedServices(groupId, user.getUserId());
    }

    public void deleteGroupUsers(long groupId, long[] userIds) throws SystemException {
        super.deleteGroupUsers(groupId, userIds);
        this.removeUsersFromVRERelatedServices(groupId, userIds);
    }

    public void deleteGroupUsers(long groupId, List<User> Users) throws SystemException {
        super.deleteGroupUsers(groupId, Users);
        for (User user : Users) {
            this.removeUserFromVREReleatedServices(groupId, user.getUserId());
        }
    }

    private void addUsersToVRERelatedServices(long groupId, long[] userId) {
        for (int i = 0; i < userId.length; ++i) {
            this.addUserToVRERelatedServices(groupId, userId[i]);
        }
    }

    private void addUserToVRERelatedServices(long groupId, long userId) {
        _log.debug((Object)"GCube VRE Folder hook addGroupUser intercepted, trying to add user to VRE Folder");
        LiferayGroupManager gm = new LiferayGroupManager();
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        try {
            if (gm.isVRE(groupId).booleanValue()) {
                _log.debug((Object)"Group is a VRE, proceeding with association ...");
                String contextOfVRE = gm.getInfrastructureScope(groupId);
                LiferayUserManager um = new LiferayUserManager();
                String username = um.getUserById(userId).getUsername();
                Thread t = new Thread((Runnable)new CheckShareLatexUserThread(username, contextOfVRE));
                t.start();
                this.setUser2VREFolder((GroupManager)gm, (UserManager)um, username, contextOfVRE, true);
            } else {
                _log.debug((Object)"Group is not a VRE, SKIP adding");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScopeProvider.instance.set(currScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setUser2VREFolder(GroupManager gm, UserManager uMan, String username2Add, String context, boolean add) throws Exception {
        String previousToken = SecurityTokenProvider.instance.get();
        String previousUMAToken = AccessTokenProvider.instance.get();
        try {
            AuthUtil.setInfraManagerLegacyAndUMATokenInThreadLocal();
            _log.info((Object)"\n*VREFolder-Hook** new authorizationService PortalClient UMA-Token In ThreadLocal done  ****\n\n");
            String vreFolderNameForsHub = GCubeHookUserLocalService.getVREFolderNameFromContext((String)context);
            GroupManagerClient client = (GroupManagerClient)AbstractPlugin.groups().build();
            if (add) {
                client.addUserToGroup(username2Add, vreFolderNameForsHub);
            } else {
                client.removeUserFromGroup(username2Add, vreFolderNameForsHub);
            }
        }
        finally {
            AccessTokenProvider.instance.set(previousUMAToken);
            SecurityTokenProvider.instance.set(previousToken);
            _log.warn((Object)("An error occurred (or the user was already member) when trying to remove or add the user " + username2Add + " to the VRE context: " + context));
        }
        _log.info((Object)("*VREFolder-Hook** " + username2Add + " was added or removed succefully from this VRE Folder. Added? (if false was removed)" + add));
        return true;
    }

    private static String getVREFolderNameFromContext(String context) {
        if (context.startsWith("/")) {
            return context.substring(1).replace("/", "-");
        }
        return null;
    }

    private void removeUsersFromVRERelatedServices(long groupId, long[] userId) {
        for (int i = 0; i < userId.length; ++i) {
            this.removeUserFromVREReleatedServices(groupId, userId[i]);
        }
    }

    private void removeUserFromVREReleatedServices(long groupId, long userId) {
        _log.debug((Object)"GCube VRE Folder hook removeUserFromHLVREFolder intercepted, trying to remove user from VRE Folder");
        LiferayGroupManager gm = new LiferayGroupManager();
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        try {
            if (gm.isVRE(groupId).booleanValue()) {
                _log.debug((Object)"Group is a VRE, proceeding with removal ...");
                String contextOfVRE = gm.getInfrastructureScope(groupId);
                LiferayUserManager um = new LiferayUserManager();
                String username = um.getUserById(userId).getUsername();
                this.setUser2VREFolder((GroupManager)gm, (UserManager)um, username, contextOfVRE, false);
                Thread tToken = new Thread((Runnable)new RemoveUserTokenFromVREThread(username, contextOfVRE));
                tToken.start();
            } else {
                _log.debug((Object)"Group is not a VRE, SKIP removal");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScopeProvider.instance.set(currScope);
    }
}

