/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins.thread;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.plugins.bean.LDAPInfo;
import org.gcube.portal.plugins.util.LDAPUtil;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;

/*
 * Exception performing whole class analysis ignored.
 */
public class UpdateUserToLDAPGroupThread
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(UpdateUserToLDAPGroupThread.class);
    private String username;
    private String scope;
    private long vreGroupId;
    private boolean remove;

    public UpdateUserToLDAPGroupThread(String username, String scope, long vreGroupId, boolean remove) {
        this.username = username;
        this.scope = scope;
        this.vreGroupId = vreGroupId;
        this.remove = remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(this.scope);
        LDAPInfo info = LDAPUtil.getLDAPCoordinates();
        LiferayGroupManager gm = new LiferayGroupManager();
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", info.getLdapUrl());
        env.put("java.naming.security.principal", info.getPrincipal());
        env.put("java.naming.security.credentials", info.getLdapPassword());
        try {
            GCubeGroup root = LDAPUtil.getRootVO();
            GCubeGroup vre = gm.getGroup(this.vreGroupId);
            GCubeGroup vo = gm.getGroup(vre.getParentGroupId());
            InitialDirContext ctx = new InitialDirContext(env);
            String subCtx = LDAPUtil.getOrgSubContext((String)root.getGroupName());
            String orgSubCtx = "ou=" + vo.getGroupName() + "," + subCtx;
            String vreSubCtx = "cn=" + vre.getGroupName() + "," + orgSubCtx;
            if (!LDAPUtil.checkIfLDAPGroupExists((DirContext)ctx, (String)vreSubCtx)) {
                LDAPUtil.createGroupVRE((DirContext)ctx, (String)vreSubCtx, (String)vre.getGroupName());
            }
            if (this.remove) {
                UpdateUserToLDAPGroupThread.removeUserFromGroup((String)this.username, (DirContext)ctx, (String)vreSubCtx, (GCubeGroup)vre);
            } else {
                UpdateUserToLDAPGroupThread.addUsertoGroup((String)this.username, (DirContext)ctx, (String)vreSubCtx, (GCubeGroup)vre);
            }
        }
        catch (NamingException e) {
            _log.error((Object)"Something went Wrong during UpdateUserToLDAPGroupThread");
            e.printStackTrace();
        }
        catch (Exception es) {
            _log.error((Object)"Something went Wrong during UpdateUserToLDAPGroupThread in retrieving Liferay Organization");
            es.printStackTrace();
        }
        finally {
            ScopeProvider.instance.set(currScope);
        }
        ScopeProvider.instance.set(currScope);
    }

    private static void addUsertoGroup(String username, DirContext ctx, String vreSubCtx, GCubeGroup vre) {
        String user = username;
        try {
            BasicAttribute memberUid = new BasicAttribute("memberUid");
            memberUid.add(user);
            BasicAttributes attributes = new BasicAttributes();
            attributes.put(memberUid);
            ctx.modifyAttributes(vreSubCtx, 1, (Attributes)attributes);
            _log.info((Object)("Added user: " + user + " to VRE: " + vre.getGroupName()));
        }
        catch (NamingException ex) {
            _log.warn((Object)("Not adding already existing user: " + user));
        }
    }

    private static void removeUserFromGroup(String username, DirContext ctx, String vreSubCtx, GCubeGroup vre) {
        String user = username;
        try {
            BasicAttribute memberUid = new BasicAttribute("memberUid");
            memberUid.add(user);
            BasicAttributes attributes = new BasicAttributes();
            attributes.put(memberUid);
            ctx.modifyAttributes(vreSubCtx, 3, (Attributes)attributes);
            _log.info((Object)("Removed user: " + user + " from VRE: " + vre.getGroupName()));
        }
        catch (NamingException ex) {
            _log.warn((Object)("Not removing, not existing user? " + user));
        }
    }
}

