/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalService;
import com.liferay.portal.service.UserGroupRoleLocalServiceWrapper;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.List;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeHookSiteRoleLocalService
extends UserGroupRoleLocalServiceWrapper {
    private static final Logger _log = LoggerFactory.getLogger(GCubeHookSiteRoleLocalService.class);
    private GroupManager gm = new LiferayGroupManager();

    public GCubeHookSiteRoleLocalService(UserGroupRoleLocalService userGroupRoleLocalService) {
        super(userGroupRoleLocalService);
        System.out.println("GCubeHookSiteRoleLocalService hook is UP & Listening ...");
    }

    public List<UserGroupRole> addUserGroupRoles(long userId, long groupId, long[] roleIds) throws SystemException {
        List toReturn = super.addUserGroupRoles(userId, groupId, roleIds);
        try {
            _log.debug("Check if addUserGroupRoles is done in a VRE");
            if (this.gm.isVRE(groupId).booleanValue()) {
                _log.debug("addUserGroupRoles performed in a VRE, groupId=" + groupId);
                boolean vreManagerRolePresent = false;
                int i = 0;
                while (i < roleIds.length) {
                    Role role = RoleLocalServiceUtil.getRole((long)roleIds[i]);
                    if (role.getName().compareTo("VRE-Manager") == 0) {
                        _log.info("User is being promoted (or was) as VREFolder Administrator, userId=" + userId + " on Site groupId=" + groupId);
                        vreManagerRolePresent = true;
                        break;
                    }
                    ++i;
                }
                this.setVREFolderAdministrator(userId, groupId, vreManagerRolePresent);
            } else {
                _log.debug("addUserGroupRoles NOT done in a VRE, groupId=" + groupId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private void setVREFolderAdministrator(long userId, long groupId, boolean enable) throws Exception {
        String scopeVREFolder = this.gm.getInfrastructureScope(groupId);
        String currScope = ScopeProvider.instance.get();
        String scopeToset = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(scopeToset);
        String username = UserLocalServiceUtil.getUser((long)userId).getScreenName();
        _log.info("User " + username + " is going to be VRE Folder Admin?" + enable);
        UserManager hlUm = HomeLibrary.getHomeManagerFactory().getUserManager();
        if (enable) {
            hlUm.setAdministrator(scopeVREFolder, username);
        } else {
            hlUm.removeAdministrator(scopeVREFolder, username);
        }
        ScopeProvider.instance.set(currScope);
    }
}

