/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.common.portal.PortalContext;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.portal.oidc.lr62.JWTCacheProxy;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;

public class PostLoginAction
extends Action {
    protected static final Log log = LogFactoryUtil.getLog(PostLoginAction.class);
    public static boolean REQUEST_UMA_ALSO_WITH_REDIRECT = true;

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        if (log.isInfoEnabled()) {
            log.info((Object)"PostLoginAction invoked");
        }
        JWTToken token = JWTTokenUtil.getOIDCFromRequest((HttpServletRequest)request);
        HttpSession session = request.getSession(false);
        String redirect = (String)request.getAttribute("redirect-after-login-to");
        if (token != null && session != null) {
            User user = (User)session.getAttribute("USER");
            if (user != null) {
                log.info((Object)("Setting OIDC token in proxy for user " + user.getScreenName() + " and session " + session.getId()));
                JWTCacheProxy.getInstance().setOIDCToken(user, session.getId(), token);
            } else {
                log.error((Object)("User object not found in session " + session.getId() + " [" + Integer.toHexString(session.hashCode()) + "]"));
            }
            if (redirect == null || REQUEST_UMA_ALSO_WITH_REDIRECT) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting current infrastructure context via portal context class");
                }
                String currentContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
                OIDCUmaUtil.checkUMATicketAndProvideInThreadLocal((HttpServletRequest)request, (HttpServletResponse)response, (User)user, (HttpSession)session, (String)currentContext);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("UMA token will be set by the valve after the redirection to: " + redirect));
            }
        } else {
            if (token == null) {
                log.error((Object)"OIDC token object is null in request");
            }
            if (session == null) {
                log.error((Object)"Session is null");
            }
        }
        if (redirect != null) {
            if (!response.isCommitted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirecting to the original requested URI: " + redirect));
                }
                try {
                    response.sendRedirect(URLDecoder.decode(redirect, "UTF-8"));
                }
                catch (IOException e) {
                    new ActionException("Redirecting to original requested URI: " + redirect, (Throwable)e);
                }
            } else {
                log.warn((Object)("Cannot redirect to original redirect URI (" + redirect + ") since the response is already commited"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No original requested URI has been found in session");
        }
    }
}

