/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.PwdGenerator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.oidc.OIDCToSitesAndRolesMapper;
import org.gcube.oidc.URLEncodedContextMapper;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;
import org.gcube.portal.oidc.lr62.UserSitesToGroupsAndRolesMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class OpenIdConnectAutoLogin
extends BaseAutoLogin {
    private static final Log log = LogFactoryUtil.getLog(OpenIdConnectAutoLogin.class);
    private static final boolean ASSURE_AVATAR_FORMAT = true;
    private static final String DEFAULT_AVATAR_FORMAT = "png";
    private static final boolean DELETE_AVATAR_IF_NOT_FOUND_ON_SERVER = false;

    public String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portalURL;
        long groupId;
        JWTToken token = JWTTokenUtil.getOIDCFromRequest((HttpServletRequest)request);
        if (token == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"OIDC token is null. Can't perform auto login");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Perform auto login with OIDC token " + token.getTokenEssentials()));
        }
        LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration((HttpServletRequest)request);
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        User user = OpenIdConnectAutoLogin.createOrUpdateUser((JWTToken)token, (long)companyId, (long)(groupId = PortalUtil.getScopeGroupId((HttpServletRequest)request)), (String)(portalURL = PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)true)), (LiferayOpenIdConnectConfiguration)configuration);
        if (user != null) {
            log.info((Object)"Applying sites and roles strategy");
            try {
                UserSitesToGroupsAndRolesMapper mapper = new UserSitesToGroupsAndRolesMapper(user, (OIDCToSitesAndRolesMapper)new URLEncodedContextMapper(token.getResourceNameToAccessRolesMap(Arrays.asList("account"))));
                mapper.map();
            }
            catch (Throwable t) {
                log.error((Object)"Applying strategy", t);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Returning logged in user's info");
            }
            return new String[]{String.valueOf(user.getUserId()), UUID.randomUUID().toString(), "false"};
        }
        log.warn((Object)"User is null");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static User createOrUpdateUser(JWTToken token, long companyId, long groupId, String portalURL, LiferayOpenIdConnectConfiguration configuration) throws Exception {
        String username = token.getUserName();
        String email = token.getEmail();
        String given = token.getGiven();
        String family = token.getFamily();
        String subject = token.getSub();
        User user = null;
        try {
            user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)username);
            if (user == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No Liferay user found with username=" + username + ", trying with openId"));
                }
                if ((user = UserLocalServiceUtil.fetchUserByOpenId((long)companyId, (String)subject)) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No Liferay user found with openid=" + subject + " and email address=" + email));
                    }
                    if (!configuration.createUnexistingUser()) {
                        log.warn((Object)"Unexisting user will not be created according to configuration");
                        return null;
                    }
                    log.info((Object)("A new user will be created [email=" + email + ",given=" + given + ",family=" + family + ",subject=" + subject + ",username=" + username));
                    user = OpenIdConnectAutoLogin.addUser((long)companyId, (long)groupId, (String)portalURL, (String)email, (String)given, (String)family, (String)subject, (String)username);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"User found by its openId, other info will be updated");
                }
            }
            boolean updateUser = false;
            if (user != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User found, checking its details against userinfo for changes");
                }
                if (given != null && !given.equals(user.getFirstName())) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Given name is changed");
                    }
                    user.setFirstName(given);
                    updateUser = true;
                }
                if (family != null && !family.equals(user.getLastName())) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Last name is changed");
                    }
                    user.setLastName(family);
                    updateUser = true;
                }
                if (email != null && !email.equals(user.getEmailAddress())) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Email address is changed");
                    }
                    user.setEmailAddress(email);
                    updateUser = true;
                }
                if (subject != null && !subject.equals(user.getOpenId())) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Setting OOID subject as openid");
                    }
                    user.setOpenId(subject);
                    updateUser = true;
                }
            }
            if (updateUser) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Updating user's details with info from userinfo");
                }
                UserLocalServiceUtil.updateUser((User)user);
            }
            try {
                BufferedImage bi;
                byte[] userAvatar = OpenIdConnectRESTHelper.getUserAvatar((URL)configuration.getAvatarURL(), (JWTToken)token);
                if (userAvatar == null) return user;
                if (userAvatar.length <= 0) return user;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Assuring avatar image format as: png");
                    log.debug((Object)("Reading image stream with length: " + userAvatar.length));
                }
                if ((bi = ImageIO.read(new ByteArrayInputStream(userAvatar))) != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Converting avatar stream image format to: png");
                    }
                    ImageIO.write((RenderedImage)bi, "png", baos);
                    baos.flush();
                    baos.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Reading converted image from the BAOS");
                    }
                    userAvatar = baos.toByteArray();
                } else {
                    log.warn((Object)"Buffered image read is null!");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Saving the retrieved avatar as user's portrait");
                }
                UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])userAvatar);
                return user;
            }
            catch (Throwable t) {
                log.error((Object)"Cannot save/update/delete user's portrait", t);
                return user;
            }
        }
        catch (PortalException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static User addUser(long companyId, long groupId, String portalURL, String emailAddress, String firstName, String lastName, String openid, String username) throws SystemException, PortalException {
        String password1;
        Locale locale = LocaleUtil.getMostRelevantLocale();
        long creatorUserId = 0L;
        boolean autoPassword = false;
        String password2 = password1 = PwdGenerator.getPassword();
        boolean autoScreenName = username == null;
        String screenName = "";
        if (autoScreenName) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Screen name will be auto-generated");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Screen name will be set to: " + username));
            }
            screenName = username;
        }
        long facebookId = 0L;
        String openId = openid;
        String middleName = "";
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setPortalURL(portalURL);
        User user = UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, groupIds, organizationIds, roleIds, userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        user.setPasswordReset(false);
        user.setEmailAddressVerified(true);
        user.setReminderQueryQuestion("x");
        user.setReminderQueryAnswer("y");
        UserLocalServiceUtil.updateUser((User)user);
        return user;
    }
}

