/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import java.net.URL;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;

public class OpenIdConnectLoginFilter
extends BaseFilter {
    protected static final Log log = LogFactoryUtil.getLog(OpenIdConnectLoginFilter.class);

    public OpenIdConnectLoginFilter() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Filter created");
        }
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        User user;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting user via portal utils");
            }
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (PortalException | SystemException e) {
            throw new ServletException("Getting user using utils", e);
        }
        HttpSession session = request.getSession(false);
        JWTToken token = null;
        if (user == null) {
            String uri = request.getRequestURI();
            if (log.isDebugEnabled()) {
                log.debug((Object)("No user logged in " + uri));
            }
            String sessionId = session.getId();
            LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration((HttpServletRequest)request);
            if (request.getParameter("state") != null && request.getParameter("state").equals(sessionId)) {
                try {
                    token = OpenIdConnectRESTHelper.queryToken((String)request.getServerName(), (URL)configuration.getTokenURL(), (String)request.getParameter("code"), (String)configuration.getScope(), (String)request.getRequestURL().toString());
                }
                catch (Exception e) {
                    throw new ServletException("Querying token from OIDC server", (Throwable)e);
                }
                JWTTokenUtil.putOIDCInRequest((JWTToken)token, (HttpServletRequest)request);
            } else {
                String oidcRedirectURL = OpenIdConnectRESTHelper.buildLoginRequestURL((URL)configuration.getAuthorizationURL(), (String)request.getServerName(), (String)sessionId, (String)request.getRequestURL().toString());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirecting to OIDC server login URL: " + oidcRedirectURL));
                }
                response.sendRedirect(oidcRedirectURL);
                return;
            }
        }
        this.processFilter(this.getClass(), request, response, filterChain);
    }

    protected Log getLog() {
        return log;
    }
}

