/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;
import org.gcube.portal.oidc.lr62.OIDCTokenCacheProxy;

public class SessionDestroyAction
extends SessionAction {
    protected static final Log log = LogFactoryUtil.getLog(SessionDestroyAction.class);

    public void run(HttpSession session) throws ActionException {
        LiferayOpenIdConnectConfiguration configuration;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Session details: id=" + session.getId() + ", instance=" + session));
        }
        if ((configuration = LiferayOpenIdConnectConfiguration.getConfiguration()).logoutOnPortalLogout()) {
            JWTToken token = JWTTokenUtil.getOIDCFromSession((HttpSession)session);
            if (token != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Performing logout on OIDC server due to session destroy");
                }
                try {
                    List tokenAud = token.getAud();
                    tokenAud.remove("account");
                    String clientId = (String)tokenAud.iterator().next();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Performing logout from the client: " + clientId));
                    }
                    OpenIdConnectRESTHelper.logout((JWTToken)token, (URL)configuration.getLogoutURL(), (String)clientId);
                }
                catch (IOException e) {
                    throw new ActionException("Performing logut on OIDC server", (Throwable)e);
                }
            } else {
                log.warn((Object)"Cannot find the OIDC token in session");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Don't performing OIDC logout according to configuration");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing OIDC tokens from cache proxy");
        }
        User user = (User)session.getAttribute("USER");
        OIDCTokenCacheProxy.getInstance().removeOIDCToken(user, session);
        OIDCTokenCacheProxy.getInstance().removeUMAToken(user, session);
    }
}

