/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.notifications.database.connections.CassandraClusterConnection;

public class NotificationSetterServlet
extends HttpServlet {
    private static final Log logger = LogFactoryUtil.getLog(NotificationSetterServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DatabookStore store = CassandraClusterConnection.getConnection();
        if (store == null) {
            logger.error((Object)"Not reachable infrastructure sorry.");
            return;
        }
        String notificationKey = request.getParameter("notificationKey");
        String username = request.getParameter("username");
        if (notificationKey != null && !notificationKey.isEmpty()) {
            try {
                logger.debug((Object)("Trying to set to read notification with key=" + notificationKey));
                store.setNotificationRead(notificationKey);
                logger.debug((Object)"Ok, set to read");
            }
            catch (Exception e) {
                logger.error((Object)("Unable to delete notification with key = " + notificationKey), (Throwable)e);
            }
        } else if (username != null && !username.isEmpty()) {
            try {
                logger.debug((Object)("Trying to set to read notifications for user=" + username));
                store.setAllNotificationReadByUser(username);
                logger.debug((Object)"Ok, set to read");
            }
            catch (Exception e) {
                logger.error((Object)("Unable to delete notification with key = " + notificationKey), (Throwable)e);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

