/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.UserNotificationEvent;
import com.liferay.portal.service.UserNotificationEventLocalServiceUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.gcube.portal.notifications.NotificationCheckerServlet;
import org.gcube.portal.notifications.database.connections.ConnectionDBLiferay;

public class CleanerUserNotificationsThread
extends Thread {
    private String username;
    private long longUserId;
    private NotificationCheckerServlet launcher;
    private static final int CLEANER_THREAD_SLEEP_TIME = 2000;
    private static final Log logger = LogFactoryUtil.getLog(CleanerUserNotificationsThread.class);

    CleanerUserNotificationsThread(String key, long longUserId, NotificationCheckerServlet launcher) {
        this.username = key;
        this.longUserId = longUserId;
        this.launcher = launcher;
    }

    public void run() {
        logger.debug((Object)("Cleaner thread starts running to remove notifications of user " + this.username));
        try {
            this.deleteNotifications();
            this.deleteBySql();
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            logger.error((Object)"Error in cleaner thread ", (Throwable)e);
        }
        this.launcher.cleanerFinished(this.username);
        logger.debug((Object)("Cleaner thread ends for user " + this.username));
    }

    private void deleteNotifications() {
        try {
            List toDelete = UserNotificationEventLocalServiceUtil.getUserNotificationEvents((long)this.longUserId);
            for (UserNotificationEvent userNotificationEvent : toDelete) {
                try {
                    UserNotificationEventLocalServiceUtil.deleteUserNotificationEvent((UserNotificationEvent)userNotificationEvent);
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to delete notification with key" + userNotificationEvent.getPrimaryKey() + " for user " + this.username));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to retrieve notifications events for user  " + this.username), (Throwable)e);
        }
    }

    private void deleteBySql() {
        Connection connection = null;
        try {
            connection = ConnectionDBLiferay.getConnection();
            String delete = "DELETE FROM \"notifications_usernotificationevent\" where \"userid\" = ?;";
            PreparedStatement statement = connection.prepareStatement(delete);
            statement.setLong(1, this.longUserId);
            int res = statement.executeUpdate();
            logger.debug((Object)("Delete " + res + " rows after execution of query " + statement.toString()));
            if (res > 0) {
                this.launcher.writeErrorEvent("[ERROR]: there were " + res + " user notifications events that didn't match with existing notifications for user " + this.username);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception while deleting notifications events from liferay", (Throwable)e);
        }
    }
}

