/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.removeaccount.thread;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;

public class RemoveUserTokenFromInfraThread
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(RemoveUserTokenFromInfraThread.class);
    private String username;

    public RemoveUserTokenFromInfraThread(String username) {
        this.username = username;
    }

    @Override
    public void run() {
        String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set(infraContext);
        try {
            String userToken = Constants.authorizationService().resolveTokenByUserAndContext(this.username, infraContext);
            SecurityTokenProvider.instance.set(userToken);
            Constants.authorizationService().removeAllReleatedToken(this.username, infraContext);
            _log.info((Object)("*** Removed user token " + this.username + " in " + infraContext));
        }
        catch (Exception e) {
            _log.error((Object)("Could not remove user token " + this.username + " in " + infraContext), (Throwable)e);
        }
    }
}

