package org.gcube.portal.removeaccount.thread;

import java.util.List;

import javax.portlet.PortletPreferences;

import org.gcube.common.portal.PortalContext;
import org.gcube.common.portal.mailing.EmailNotification;
import org.gcube.portal.usersaccount.Constants;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;


/**
 * 
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class RemovedUserAccountThread implements Runnable {

	private static final Logger _log = LoggerFactory.getLogger(RemovedUserAccountThread.class);

	final String SUBJECT = "Removed account notification";

	private String userName;
	private GroupManager gm;
	private UserManager uMan;

	public RemovedUserAccountThread(long userId,String userName) {
		super();
		this.userName = userName;
		this.uMan = new LiferayUserManager();
		this.gm = new LiferayGroupManager();
	}

	@Override
	public void run() {
		try {
			_log.info("Trying to remove user " + userName + " from JCR first, using storageHub with role: "+Constants.AUTORISED_INFRA_ROLE);
			RemoveUserFromJCR rmJCR = new RemoveUserFromJCR(userName, gm, uMan);
			boolean result = rmJCR.remove();
			_log.info("The user " + userName + " has been removed from JCR with success? " + result);
				
		} catch (Exception e) {
			_log.error("An error occurred during user workspace removal: ", e);
		}
	}
}
