/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.usersaccount;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.User;
import org.gcube.portal.notifications.thread.NewUserAccountNotificationThread;
import org.gcube.portal.removeaccount.thread.RemovedUserAccountThread;
import org.gcube.portal.removeaccount.thread.RemovedUserFromLDAPThread;
import org.gcube.portal.usersaccount.WorkspaceCreateAccountThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCreateUserAccountListener
extends BaseModelListener<User> {
    private static final Logger _log = LoggerFactory.getLogger(MyCreateUserAccountListener.class);
    final String SUBJECT = "New user account notification";

    public void onAfterCreate(User user) throws ModelListenerException {
        _log.info("onAfterCreate NewUserAccount listener for: " + user.getScreenName() + " / " + user.getFullName());
        Thread emailManagersThread = new Thread((Runnable)new NewUserAccountNotificationThread(user.getScreenName(), user.getFullName(), user.getEmailAddress()));
        emailManagersThread.start();
        Thread WorkspaceAccountCreationThread = new Thread((Runnable)new WorkspaceCreateAccountThread(user.getScreenName(), user.getFullName(), user.getEmailAddress()));
        WorkspaceAccountCreationThread.start();
    }

    public void onBeforeRemove(User user) throws ModelListenerException {
        _log.info("onBeforeRemove userAccount listener for: " + user.getScreenName() + " / " + user.getFullName());
        String username2Delete = user.getScreenName();
        _log.info("Trying to remove user from JCR and not notify infra-managers ...");
        try {
            Thread dropUserWorkspaceThread = new Thread((Runnable)new RemovedUserAccountThread(user.getUserId(), username2Delete));
            dropUserWorkspaceThread.start();
            _log.info("Trying to remove user from LDAP ...");
            Thread removeFromLDAPThread = new Thread((Runnable)new RemovedUserFromLDAPThread(username2Delete));
            removeFromLDAPThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

