/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.landingpage;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.landingpage.ResourceCatalogueAndSBDLabRegistrationThread;
import org.gcube.portal.notifications.thread.NewUserSiteRegistrationNotificationThread;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;

public class LandingPageManager {
    private static Log _log = LogFactoryUtil.getLog(LandingPageManager.class);
    public static final String GUEST_GROUP_FRIENDLY_URL = "/guest";
    public static final String PRIVATE_GROUP_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.private.group.servlet.mapping");
    public static final String PORTAL_CONTEXT = PortalUtil.getPathContext();
    private static final String SBD_GATEWAY_VHOST = "sobigdata.d4science.org";

    public static String getLandingPagePath(HttpServletRequest request) throws PortalException, SystemException {
        User currentUser = PortalUtil.getUser((HttpServletRequest)request);
        _log.info((Object)("getLandingPagePath called for user " + currentUser.getScreenName()));
        return LandingPageManager.getLandingPagePath(request, currentUser);
    }

    public static String getLandingPagePath(HttpServletRequest request, User currentUser) throws PortalException, SystemException {
        String sitePath = "";
        String currentVirtualHost = request.getServerName();
        _log.info((Object)("currentHost is " + currentVirtualHost));
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            _log.debug((Object)("Found  " + virtualHost.getHostname()));
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(currentVirtualHost) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            _log.debug((Object)("Found match! Your site is " + site.getName()));
            List<Group> userSites = LandingPageManager.getSites(currentUser.getUserId());
            boolean isRegistered = false;
            for (Group group : userSites) {
                if (group.getGroupId() != site.getGroupId()) continue;
                isRegistered = true;
                _log.debug((Object)("user " + currentUser.getFullName() + " is registered to " + site.getName() + ". redirecting ..."));
                break;
            }
            if (isRegistered) break;
            _log.info((Object)("But user " + currentUser.getFullName() + " is not registered to " + site.getName() + ". going to register ..."));
            String portalURL = PortalContext.getConfiguration().getGatewayURL(request);
            LandingPageManager.registerUserToSite(currentUser, site, portalURL);
            if (!currentVirtualHost.equalsIgnoreCase(SBD_GATEWAY_VHOST)) break;
            _log.debug((Object)"currentVirtualHost.equalsIgnoreCase ->sobigdata.d4science.org");
            Thread resourceCatalogueSBDThread = new Thread(new ResourceCatalogueAndSBDLabRegistrationThread(userSites, currentUser, portalURL));
            resourceCatalogueSBDThread.start();
            break;
        }
        if (site.getPrivateLayoutsPageCount() > 0) {
            sitePath = LandingPageManager.getGroupFriendlyURL(request, site);
        } else {
            _log.debug((Object)(site.getName() + " site doesn't have any private page. Default landing page will be used"));
        }
        return sitePath;
    }

    protected static void registerUserToSite(User user, Group site, String siteURL) throws SystemException {
        UserLocalServiceUtil.addGroupUser((long)site.getGroupId(), (long)user.getUserId());
        _log.debug((Object)("User " + user.getScreenName() + " registered to " + site.getName()));
        Thread emailSiteManagersThread = new Thread((Runnable)new NewUserSiteRegistrationNotificationThread((UserManager)new LiferayUserManager(), (RoleManager)new LiferayRoleManager(), user, site, siteURL));
        emailSiteManagersThread.start();
    }

    public static List<Group> getSites(long userId) throws PortalException, SystemException {
        ArrayList<Group> sites = new ArrayList<Group>();
        for (Group group : GroupLocalServiceUtil.getUserGroups((long)userId)) {
            if (!group.isRegularSite() || GUEST_GROUP_FRIENDLY_URL.equalsIgnoreCase(group.getFriendlyURL())) continue;
            sites.add(group);
        }
        return sites;
    }

    public static String getGroupFriendlyURL(HttpServletRequest request, Group currentGroup) throws PortalException, SystemException {
        String friendlyURL = PRIVATE_GROUP_SERVLET_MAPPING;
        StringBundler sb = new StringBundler();
        sb.append(PORTAL_CONTEXT);
        sb.append(friendlyURL);
        sb.append(currentGroup.getFriendlyURL());
        return sb.toString();
    }
}

