/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr62.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Role;
import org.gcube.portal.event.publisher.lr62.model.PortalModelListenerEvent;

public class RoleEvent
extends PortalModelListenerEvent<Role> {
    private static final long serialVersionUID = 3939268094440017646L;
    public static final String CREATED_NAME = "Role_created";
    public static final String DELETED_NAME = "Role_deleted";
    public static final String UPDATED_NAME = "Role_updated";
    public static final String OLD_ROLE_ENTRY = "old-role";

    private RoleEvent(String name, Role role) throws PortalException, SystemException {
        super(name, (BaseModel)role);
        this.setRole(role);
    }

    private RoleEvent(String name, Role oldRole, Role newRole) throws PortalException, SystemException {
        this(name, newRole);
        this.setOldRole(oldRole);
    }

    public void setOldRole(String role) {
        this.set(OLD_ROLE_ENTRY, role);
    }

    public String getOldRole() {
        return (String)this.get((Object)OLD_ROLE_ENTRY);
    }

    private void setOldRole(Role oldRole) throws PortalException, SystemException {
        this.setOldRole(this.getRoleIdentifier(oldRole));
    }

    public static RoleEvent newCreatedEvent(Role role) {
        try {
            return new RoleEvent(CREATED_NAME, role);
        }
        catch (PortalException | SystemException e) {
            log.error((Object)"Cannot create event from Role model object", e);
            return null;
        }
    }

    public static RoleEvent newDeletedEvent(Role role) {
        try {
            return new RoleEvent(DELETED_NAME, role);
        }
        catch (PortalException | SystemException e) {
            log.error((Object)"Cannot create event from Role model object", e);
            return null;
        }
    }

    public static RoleEvent newUpdatedEvent(Role oldRole, Role newRole) {
        try {
            return new RoleEvent(UPDATED_NAME, oldRole, newRole);
        }
        catch (PortalException | SystemException e) {
            log.error((Object)"Cannot create event from Role model object", e);
            return null;
        }
    }
}

