package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate = true, service = ModelListener.class)
public class UserGroupRoleModelListener extends BaseModelListener<UserGroupRole> {

    @Reference
    private EventPublisherFacade eventPublisherFacade;

    @Reference
    private GroupLocalService groupLocalService;

    @Override
    public void onAfterCreate(UserGroupRole userGroupRole) {
        Group group = groupLocalService.fetchGroup(userGroupRole.getGroupId());
        // LR6.2 behavior: publish only for active Site groups
        if (group == null || !group.isSite() || !group.isActive()) {
            return;
        }
        java.util.Map<String, Object> payload = new java.util.HashMap<>();
        payload.put("event", "USER_GROUP_ROLE_ADD");
        payload.put("userId", userGroupRole.getUserId());
        payload.put("groupId", userGroupRole.getGroupId());
        payload.put("roleId", userGroupRole.getRoleId());
        eventPublisherFacade.publish("usergrouprole.event", payload);
    }

    @Override
    public void onAfterRemove(UserGroupRole userGroupRole) {
        Group group = groupLocalService.fetchGroup(userGroupRole.getGroupId());
        // LR6.2 behavior: publish only for active Site groups
        if (group == null || !group.isSite() || !group.isActive()) {
            return;
        }
        java.util.Map<String, Object> payload = new java.util.HashMap<>();
        payload.put("event", "USER_GROUP_ROLE_REMOVE");
        payload.put("userId", userGroupRole.getUserId());
        payload.put("groupId", userGroupRole.getGroupId());
        payload.put("roleId", userGroupRole.getRoleId());
        eventPublisherFacade.publish("usergrouprole.event", payload);
    }
}