package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleConstants;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate = true, service = ModelListener.class)
public class RoleModelListener extends BaseModelListener<Role> {

    @Reference
    private EventPublisherFacade eventPublisherFacade;

    @Override
    public void onAfterCreate(Role role) {
        // LR6.2 behavior: publish only for Site roles
        if (role.getType() != RoleConstants.TYPE_SITE) {
            return;
        }
        java.util.Map<String, Object> payload = new java.util.HashMap<>();
        payload.put("event", "ROLE_CREATE");
        payload.put("roleId", role.getRoleId());
        payload.put("name", role.getName());
        payload.put("type", role.getType());
        eventPublisherFacade.publish("role.event", payload);
    }

    // LR6.2 did not publish update events for roles

    @Override
    public void onAfterRemove(Role role) {
        // LR6.2 behavior: publish only for Site roles
        if (role.getType() != RoleConstants.TYPE_SITE) {
            return;
        }
        java.util.Map<String, Object> payload = new java.util.HashMap<>();
        payload.put("event", "ROLE_DELETE");
        payload.put("roleId", role.getRoleId());
        payload.put("name", role.getName());
        eventPublisherFacade.publish("role.event", payload);
    }
}