package org.gcube.portal.event.publisher.lr74.action;

import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.events.LifecycleEvent;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.osgi.service.component.annotations.Component;

@Component(
    immediate = true,
    service = LifecycleAction.class,
    property = {
        "key=application.shutdown.events"
    }
)
public class ShutdownAction implements LifecycleAction {

    private static final Log _log = LogFactoryUtil.getLog(ShutdownAction.class);

    @Override
    public void processLifecycleEvent(LifecycleEvent lifecycleEvent) {
        _log.info("[EventPublisher] ShutdownAction invoked");
        try {
            org.gcube.portal.event.publisher.lr74.model.EventPublisherFacade.getInstance()
                .onShutdown();
        } catch (Exception e) {
            _log.error("ShutdownAction failed", e);
        }
    }
}