package org.gcube.portal.event.publisher.lr62.model;

import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;

public class UserEvent extends PortalModelListenerEvent<User> {

    private static final long serialVersionUID = 3939268094440017646L;

    public static final String CREATED_NAME = "user_created";
    public static final String DELETED_NAME = "user_deleted";

    public static final String UG_CREATED_NAME = "user-group_created";
    public static final String UG_DELETED_NAME = "user-group_deleted";

    private UserEvent(String name, User user) throws UserManagementSystemException, UserRetrievalFault {
        super(name, user, user);
    }

    private UserEvent(String name, User user, Group group)
            throws PortalException, SystemException, UserManagementSystemException, UserRetrievalFault {

        this(name, user);
        setGroup(group);
    }

    public static UserEvent newCreatedEvent(User user) {
        try {
            return new UserEvent(CREATED_NAME, user);
        } catch (UserManagementSystemException | UserRetrievalFault e) {
            log.error("Cannot create event from User model object", e);
            return null;
        }
    }

    public static UserEvent newDeletedEvent(User user) {
        try {
            return new UserEvent(DELETED_NAME, user);
        } catch (UserManagementSystemException | UserRetrievalFault e) {
            log.error("Cannot create event from User model object", e);
            return null;
        }
    }


    public static UserEvent newCreatedEvent(User user, Group group) {
        try {
            return new UserEvent(UG_CREATED_NAME, user, group);
        } catch (PortalException | SystemException | UserManagementSystemException | UserRetrievalFault e) {
            log.error("Cannot create event from one model object", e);
            return null;
        }
    }

    public static UserEvent newDeletedEvent(User user, Group group) {
        try {
            return new UserEvent(UG_DELETED_NAME, user, group);
        } catch (PortalException | SystemException | UserManagementSystemException | UserRetrievalFault e) {
            log.error("Cannot create event from one model object", e);
            return null;
        }
    }

}
