/* The following function simply injects the Liferay object fields userId and scopeGroupId in the XMLHttpRequest header.
 * So that every ajax call performed in the page has those parameters set.
 * Author: Massimiliano Assante, CNR-ISTI */
function injectClientContext() {
	if (Liferay != null) {
		var userId;
		var groupId;
		if (Liferay.ThemeDisplay.isSignedIn()) {
			userId = Liferay.ThemeDisplay.getUserId();
			groupId = Liferay.ThemeDisplay.getScopeGroupId();
			//console.log('userId is = ' + userId);
			//console.log("groupId is = " + groupId);
		}
		else {
			groupId = Liferay.ThemeDisplay.getScopeGroupId();
			//console.log('Not logged in, injecting groupId only');
		}

		XMLHttpRequest.prototype.realSend = XMLHttpRequest.prototype.send;
		var newSend = function(vData) {
			this.setRequestHeader("gcube-userId", userId);
			this.setRequestHeader("gcube-vreid", groupId);
			this.realSend(vData);
		};
		XMLHttpRequest.prototype.send = newSend;
	}
}