/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.searchtester.plugin.tests;

import java.util.ArrayList;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.sam.reports.search.CombinedSearchReport;
import org.gcube.tools.searchtester.plugin.ASLHTTPRequest;
import org.gcube.tools.searchtester.plugin.CollectionInfo;
import org.gcube.tools.searchtester.plugin.ParamMap;
import org.gcube.tools.searchtester.plugin.PluginContext;
import org.gcube.tools.searchtester.plugin.tests.BaseTest;
import org.gcube.tools.searchtester.plugin.tests.TestResult;
import org.gcube.tools.searchtester.plugin.util.Util;

public class CombinedSearchTest
extends BaseTest {
    public CombinedSearchTest() {
        this.reports = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() {
        CombinedSearchReport report = null;
        boolean testable = false;
        for (CollectionInfo coll : PluginContext.collectionsMap.get(this.vre)) {
            for (CollectionInfo.Schema schema : coll.getAvailableSchemata()) {
                try {
                    report = new CombinedSearchReport();
                    ParamMap parameters = new ParamMap();
                    parameters.addParameter("scope", this.vre);
                    parameters.addParameter("searchType", "combined");
                    report.setVre(this.vre);
                    report.setCollectionName(coll.getName());
                    report.setCollectionID(coll.getId());
                    report.setSchemaName(schema.getName());
                    report.setSchemaLanguage(schema.getLanguage());
                    if (coll.getMetadataRecord(schema) == null) {
                        report.setResult(XMLReport.STATUS_ERROR);
                        report.setError("ERROR: No metadata records for the collections");
                        report.setExecutionTime(XMLReport.NOT_EXECUTED);
                        continue;
                    }
                    String term = Util.getRandomToken(Util.getElementFromMetadata(coll.getMetadataRecord(schema), "title"));
                    if (term.equals("")) {
                        report.setResult(XMLReport.STATUS_ABORTED);
                        report.setError("ERROR: null term selected");
                        continue;
                    }
                    if (coll.getSearchableFields(schema) == null) {
                        report.setResult(XMLReport.STATUS_ERROR);
                        report.setError("ERROR: No Searchable field Available");
                        report.setExecutionTime(XMLReport.NOT_EXECUTED);
                        continue;
                    }
                    for (String values : coll.getSearchableFields(schema)) {
                        if (values.compareTo("Title") != 0) continue;
                        testable = true;
                    }
                    if (!testable) {
                        report.setResult(XMLReport.STATUS_ERROR);
                        report.setError("ERROR: No Title Searchable field Available");
                        report.setExecutionTime(XMLReport.NOT_EXECUTED);
                        continue;
                    }
                    report.setCriteriaValues(term);
                    report.setCriteriaNames("Title");
                    parameters.addParameter("criteria", "Title-" + term);
                    parameters.addParameter("selectedCollections", coll.getId());
                    parameters.addParameter("schema", schema.getName());
                    parameters.addParameter("language", schema.getLanguage());
                    this.logger.debug((Object)("Executing Combined Search Query on collection :" + coll.getName()));
                    this.req = new ASLHTTPRequest("SearchResults", parameters);
                    TestResult results = this.req.makeRequest();
                    report.setResult(Util.checkResults(results.getResult()));
                    report.setError(results.getError());
                    report.setExecutionTime(results.getExecutionTime());
                }
                catch (Exception e) {
                    report.setError(e.toString());
                    report.setResult(XMLReport.STATUS_EXCEPTION);
                    report.setExecutionTime(XMLReport.NOT_EXECUTED);
                }
                finally {
                    this.reports.add(report);
                }
            }
        }
    }
}

