/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.searchtester.plugin;

import java.util.ArrayList;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.tools.searchtester.plugin.ASLHTTPRequest;
import org.gcube.tools.searchtester.plugin.CollectionInfo;
import org.gcube.tools.searchtester.plugin.ParamMap;
import org.gcube.tools.searchtester.plugin.PluginContext;
import org.gcube.tools.searchtester.plugin.SearchTesterWorker;
import org.gcube.tools.searchtester.plugin.is.ISTools;
import org.gcube.tools.searchtester.plugin.util.Util;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class SearchTesterTask
extends GCUBEHandler<TaskRuntime>
implements ExecutorTask {
    private boolean isScheduled = false;
    private GCUBEScheduledHandler scheduled = null;
    private SearchTesterWorker worker = null;

    public void run() throws Exception {
        TaskRuntime r = (TaskRuntime)this.getHandled();
        PluginContext.cleanInput();
        this.setState((State)State.Running.INSTANCE);
        try {
            if (r.getInput("vres") != null) {
                for (Object t : (Object[])r.getInput("vres")) {
                    PluginContext.testableVREs.add((String)t);
                }
            } else {
                r.throwException(new Exception("Missing VREs to test input parameter"));
                this.setState((State)State.Failed.INSTANCE);
                throw new Exception("Missing VREs to test input parameter");
            }
            if (r.getInput("tests") != null) {
                for (Object t : (Object[])r.getInput("tests")) {
                    PluginContext.tests.add(Class.forName((String)t));
                }
            } else {
                r.throwException(new Exception("Missing tests to run input parameter"));
                this.setState((State)State.Failed.INSTANCE);
                throw new Exception("Missing tests to run input parameter");
            }
            if ((String)r.getInput("HTTPAPIURL") == null) {
                r.throwException(new Exception("Missing new Long(-1) API URL input parameter"));
                this.setState((State)State.Failed.INSTANCE);
                throw new Exception("Missing HTTP API URL input parameter");
            }
            PluginContext.HTPPAPIURL = (String)r.getInput("HTTPAPIURL");
            if ((String)r.getInput("interval") != null) {
                String interval = (String)r.getInput("interval");
                this.logger.debug((Object)("Setting Scheduling interval to:" + interval));
                PluginContext.schedulingInterval = Long.valueOf(interval);
            }
            this.getVREs();
            if (PluginContext.getVres().isEmpty()) {
                r.throwException(new Exception("No VRE to TEST"));
                this.setState((State)State.Failed.INSTANCE);
                throw new Exception("No VRE to TEST");
            }
            this.getCollections();
            if (PluginContext.schedulingInterval == -1L) {
                this.worker = new SearchTesterWorker(this.isScheduled);
                this.worker.setHandled(this.getHandled());
                this.logger.debug((Object)"Missing scheduling interval. using DEFAULT not scheduled task");
                this.worker.setState((State)State.Running.INSTANCE);
                this.worker.run();
            } else {
                this.logger.debug((Object)("Running scheduled execution with scheduling interval set to:" + PluginContext.schedulingInterval));
                this.isScheduled = true;
                this.worker = new SearchTesterWorker(this.isScheduled);
                this.worker.setHandled(this.getHandled());
                this.scheduled = new GCUBEScheduledHandler(PluginContext.schedulingInterval, GCUBEScheduledHandler.Mode.EAGER, new GCUBEHandler[0]);
                this.scheduled.setScheduled((GCUBEHandler)this.worker);
                this.worker.setState((State)State.Running.INSTANCE);
                this.scheduled.run();
            }
            while (this.worker.getState().equals((Object)State.Running.INSTANCE)) {
                Thread.sleep(60000L);
            }
            this.setState((State)State.Done.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            r.throwException(e);
            this.setState((State)State.Failed.INSTANCE);
            PluginContext.cleanInput();
            throw new Exception("Failed to Run the Search Tester", e);
        }
    }

    public void getVREs() throws Exception {
        ASLHTTPRequest req = new ASLHTTPRequest("ShowVREs");
        PluginContext.vres = Util.parseVREXML(req.makeRequest().getResult());
    }

    public void getCollections() {
        for (String vre : PluginContext.vres) {
            try {
                ParamMap parameters = new ParamMap();
                parameters.addParameter("scope", vre);
                ASLHTTPRequest req = new ASLHTTPRequest("ShowCollections", parameters);
                PluginContext.collectionsMap.put(vre, this.getCollectionsInfo(Util.parseColletionXML(req.makeRequest().getResult()), vre));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)("ERROR getting collections for VRE :" + vre));
            }
        }
    }

    public ArrayList<CollectionInfo> getCollectionsInfo(ArrayList<CollectionInfo> collectionInfo, String scope) {
        ArrayList<CollectionInfo> colResult = new ArrayList<CollectionInfo>();
        for (CollectionInfo info : collectionInfo) {
            try {
                ParamMap parameters = new ParamMap();
                parameters.addParameter("scope", scope);
                parameters.addParameter("selectedCollections", info.getId());
                ASLHTTPRequest req = new ASLHTTPRequest("CollectionInfos", parameters);
                info = Util.parseColletionInfoXML(info, req.makeRequest().getResult(), new CollectionInfo.Schema[0]);
                colResult.add(info);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)("ERROR getting collections infos for vre :" + scope));
            }
        }
        ArrayList<CollectionInfo> colResult2 = new ArrayList<CollectionInfo>();
        for (CollectionInfo col : colResult) {
            try {
                ArrayList<CollectionInfo.Schema> schemas = new ArrayList<CollectionInfo.Schema>();
                ParamMap parameters = new ParamMap();
                parameters.addParameter("scope", scope);
                parameters.addParameter("selectedCollections", col.getId());
                for (CollectionInfo.Schema schema : col.getAvailableSchemata()) {
                    schemas.add(schema);
                }
                for (CollectionInfo.Schema schema : schemas) {
                    parameters.addParameter("schema", schema.getName());
                    parameters.addParameter("language", schema.getLanguage());
                    ASLHTTPRequest req = new ASLHTTPRequest("CollectionInfos", parameters);
                    col = Util.parseColletionInfoXML(col, req.makeRequest().getResult(), schema);
                }
                colResult2.add(col);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)("ERROR getting collections infos for vre :" + scope));
            }
        }
        ArrayList<CollectionInfo> colResult3 = new ArrayList<CollectionInfo>();
        ISTools IS = new ISTools(GCUBEScope.getScope((String)scope));
        for (CollectionInfo col : colResult2) {
            try {
                ArrayList<CollectionInfo.Schema> schemas = new ArrayList<CollectionInfo.Schema>();
                for (CollectionInfo.Schema schema : col.getAvailableSchemata()) {
                    schemas.add(schema);
                }
                ParamMap parameters = new ParamMap();
                parameters.addParameter("scope", scope);
                for (CollectionInfo.Schema schema : schemas) {
                    String mID = IS.retrieveMCollectionID(col.getId(), schema.getName(), schema.getLanguage());
                    this.logger.debug((Object)("mCollection ID " + mID));
                    if (mID == null) continue;
                    parameters.addParameter("MetadataView", mID);
                    ASLHTTPRequest req = new ASLHTTPRequest("MetadataViewer", parameters);
                    String metadata = req.makeRequest().getResult();
                    if (metadata.equals("")) {
                        this.logger.debug((Object)"not a a valid metadata record retrieved");
                    } else {
                        this.logger.debug((Object)("added metadata for collection " + col.getId() + " " + metadata));
                    }
                    col.addMetadataRecord(schema, req.makeRequest().getResult());
                }
                colResult3.add(col);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)("ERROR getting collections infos for vre :" + scope));
            }
        }
        return colResult3;
    }

    public void stop() throws UnsupportedOperationException, Exception {
        if (this.isScheduled) {
            this.scheduled.stop();
        }
        TaskRuntime r = (TaskRuntime)this.getHandled();
        r.addOutput("report", (Object)"TASK Stopped by USER");
        PluginContext.cleanInput();
        this.setState((State)State.Done.INSTANCE);
    }
}

