/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.sam.istester.plugin.tests;

import java.util.ArrayList;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEIHandler;
import org.gcube.common.core.utils.handlers.GCUBEParallelHandler;
import org.gcube.common.core.utils.handlers.GCUBESequentialHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.tools.sam.istester.plugin.Constants;
import org.gcube.tools.sam.istester.plugin.PluginContext;
import org.gcube.tools.sam.istester.plugin.tests.BaseTest;
import org.gcube.tools.sam.istester.plugin.tests.collector.ISQueryTest;
import org.gcube.tools.sam.istester.plugin.util.ISUtil;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.sam.reports.informationsystem.QueryOperationReport;

public class QueryOperationTest
extends BaseTest {
    private ISUtil isutil = null;
    ArrayList<EndpointReferenceType> icEprs = new ArrayList();

    public QueryOperationTest() {
        this.reports = new ArrayList();
        this.isutil = new ISUtil(GCUBEScope.getScope((String)PluginContext.getScope()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() {
        QueryOperationReport report = null;
        long start = 0L;
        long end = 0L;
        try {
            this.icEprs = this.isutil.getServiceEndpoint(Constants.ISCollectorServiceName, Constants.ISCollectorPortTypeName);
        }
        catch (Exception e2) {
            this.logger.debug((Object)"Failed to get IS-Collector eprs from IS");
            return;
        }
        for (EndpointReferenceType epr : this.icEprs) {
            this.logger.debug((Object)("Testing IS-Collector with epr:" + epr.toString()));
            block13: for (QueryTypes type : QueryTypes.values()) {
                int i;
                GCUBEParallelHandler handler;
                report = new QueryOperationReport();
                report.setOperation(type.name() + "_QUERY_PARALLEL");
                report.setTargetGHNName(epr.getAddress().getHost() + ":" + epr.getAddress().getPort());
                report.setTargetServiceName(Constants.ISCollectorServiceName);
                report.setVre(PluginContext.getScope());
                try {
                    handler = new GCUBEParallelHandler(new GCUBEIHandler[0]);
                    for (i = 0; i < 10; ++i) {
                        handler.addHandlers(new GCUBEIHandler[]{new ISQueryTest(type.name() + "_QUERY_PARALLEL", GCUBEScope.getScope((String)PluginContext.getScope()), epr)});
                    }
                    start = System.currentTimeMillis();
                    handler.run();
                    boolean done = false;
                    while (!done) {
                        done = true;
                        for (Object handled : handler.getHandlers()) {
                            if (!((ISQueryTest)((Object)handled)).getState().equals((Object)State.Running.INSTANCE)) continue;
                            done = false;
                        }
                        Thread.sleep(100L);
                    }
                    end = System.currentTimeMillis();
                    report.setExecutionTime(new Double((double)(end - start) / 1000.0));
                    if (handler.getFailedHandlers().keySet() != null && handler.getFailedHandlers().keySet().size() > 0) {
                        report.setResult(XMLReport.STATUS_ERROR);
                        report.setError(XMLReport.STATUS_ERROR);
                    } else {
                        report.setResult(XMLReport.STATUS_OK);
                        report.setError(XMLReport.NOT_AVAILABLE);
                    }
                }
                catch (Exception e) {
                    end = System.currentTimeMillis();
                    report.setExecutionTime(new Double((double)(end - start) / 1000.0));
                    report.setResult(XMLReport.STATUS_ERROR);
                    report.setError(e.getMessage());
                }
                finally {
                    this.reports.add(report);
                }
                report = new QueryOperationReport();
                report.setOperation(type.name() + "_QUERY_SEQUENTIAL");
                report.setTargetGHNName(epr.getAddress().getHost() + ":" + epr.getAddress().getPort());
                report.setTargetServiceName(Constants.ISCollectorServiceName);
                report.setVre(PluginContext.getScope());
                try {
                    handler = new GCUBESequentialHandler(new GCUBEIHandler[0]);
                    for (i = 0; i < 10; ++i) {
                        handler.addHandlers(new GCUBEIHandler[]{new ISQueryTest(type.name() + "_QUERY_SEQUENTIAL", GCUBEScope.getScope((String)PluginContext.getScope()), epr)});
                    }
                    start = System.currentTimeMillis();
                    handler.run();
                    while (handler.getState().equals((Object)State.Running.INSTANCE)) {
                        Thread.sleep(100L);
                    }
                    end = System.currentTimeMillis();
                    report.setExecutionTime(new Double((double)(end - start) / 1000.0));
                    report.setResult(XMLReport.STATUS_OK);
                    report.setError(XMLReport.NOT_AVAILABLE);
                    for (Object handled : handler.getHandlers()) {
                        if (!((ISQueryTest)((Object)handled)).getState().equals((Object)State.Failed.INSTANCE)) continue;
                        report.setResult(XMLReport.STATUS_ERROR);
                        report.setError(XMLReport.STATUS_ERROR);
                        continue block13;
                    }
                }
                catch (Exception e) {
                    end = System.currentTimeMillis();
                    report.setExecutionTime(new Double((double)(end - start) / 1000.0));
                    report.setResult(XMLReport.STATUS_ERROR);
                    report.setError(e.getMessage());
                }
                finally {
                    this.reports.add(report);
                }
            }
        }
    }

    public static enum QueryTypes {
        SIMPLE("SIMPLE"),
        COMPLEX("COMPLEX");

        String type;

        private QueryTypes(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

