/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.sam.istester.plugin.tests;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.tools.sam.istester.plugin.Constants;
import org.gcube.tools.sam.istester.plugin.PluginContext;
import org.gcube.tools.sam.istester.plugin.helpers.ISRegistryHelper;
import org.gcube.tools.sam.istester.plugin.tests.BaseTest;
import org.gcube.tools.sam.istester.plugin.util.ISUtil;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.sam.reports.informationsystem.ISOperationReport;
import org.gcube.tools.sam.reports.informationsystem.ProfileOperationReport;

public class ProfileOperationTest
extends BaseTest {
    private ISUtil isutil = null;
    private ISRegistryHelper helper = null;
    private GCUBEResource resource = null;
    boolean aborted = false;
    private String id = "";
    ArrayList<EndpointReferenceType> registryEprs = new ArrayList();

    public ProfileOperationTest() {
        this.reports = new ArrayList();
        this.isutil = new ISUtil(GCUBEScope.getScope((String)PluginContext.getScope()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() {
        ProfileOperationReport report = null;
        long start = 0L;
        long end = 0L;
        try {
            this.registryEprs = this.isutil.getServiceEndpoint(Constants.ISRegistryServiceName, Constants.ISRegistryPortTypeName);
        }
        catch (Exception e2) {
            this.logger.debug((Object)"Failed to get IS-Registry eprs from IS");
            return;
        }
        for (EndpointReferenceType epr : this.registryEprs) {
            try {
                this.helper = new ISRegistryHelper(GCUBEScope.getScope((String)PluginContext.getScope()));
                this.resource = this.helper.getGenericResourceResource();
                this.id = UUID.randomUUID().toString();
                this.resource.setID(this.id);
                this.logger.debug((Object)("Testing IS-Registry with epr:" + epr.toString()));
                report = new ProfileOperationReport();
                report.setOperation(ISOperationReport.ISOperations.CREATE_PROFILE.name());
                report.setTargetGHNName(epr.getAddress().getHost() + ":" + epr.getAddress().getPort());
                report.setTargetServiceName(Constants.ISRegistryServiceName);
                report.setVre(PluginContext.getScope());
                start = System.currentTimeMillis();
                this.helper.registerResource(this.resource, epr);
                end = System.currentTimeMillis();
                report.setResult(XMLReport.STATUS_OK);
                report.setError(XMLReport.NOT_AVAILABLE);
                end = System.currentTimeMillis();
                report.setExecutionTime(new Double((double)(end - start) / 1000.0));
            }
            catch (Exception e) {
                end = System.currentTimeMillis();
                report.setExecutionTime(new Double((double)(end - start) / 1000.0));
                report.setResult(XMLReport.STATUS_ERROR);
                report.setError(e.getMessage());
                this.aborted = true;
            }
            finally {
                this.reports.add(report);
            }
            boolean published = this.isutil.getSAMGenericResource(this.id);
            report = new ProfileOperationReport();
            report.setOperation(ISOperationReport.ISOperations.UPDATE_PROFILE.name());
            report.setTargetGHNName(epr.getAddress().getHost() + ":" + epr.getAddress().getPort());
            report.setTargetServiceName(Constants.ISRegistryServiceName);
            report.setVre(PluginContext.getScope());
            if (this.aborted || !published) {
                report.setResult(XMLReport.STATUS_ABORTED);
                if (!published) {
                    report.setError("Resource not published on the IS after 10m");
                } else {
                    report.setError(XMLReport.STATUS_ABORTED);
                }
                this.reports.add(report);
            } else {
                try {
                    start = System.currentTimeMillis();
                    this.resource.setID(this.id);
                    this.helper.updateResource(this.resource, epr);
                    end = System.currentTimeMillis();
                    report.setResult(XMLReport.STATUS_OK);
                    report.setError(XMLReport.NOT_AVAILABLE);
                    end = System.currentTimeMillis();
                    report.setExecutionTime(new Double((double)(end - start) / 1000.0));
                }
                catch (Exception e) {
                    end = System.currentTimeMillis();
                    report.setExecutionTime(new Double((double)(end - start) / 1000.0));
                    report.setResult(XMLReport.STATUS_ERROR);
                    report.setError(e.getMessage());
                }
                finally {
                    this.reports.add(report);
                }
            }
            report = new ProfileOperationReport();
            report.setOperation(ISOperationReport.ISOperations.DELETE_PROFILE.name());
            report.setTargetGHNName(epr.getAddress().getHost() + ":" + epr.getAddress().getPort());
            report.setTargetServiceName(Constants.ISRegistryServiceName);
            report.setVre(PluginContext.getScope());
            if (this.aborted || !published) {
                report.setResult(XMLReport.STATUS_ABORTED);
                if (!published) {
                    report.setError("Resource not published on the IS after 10m");
                } else {
                    report.setError(XMLReport.STATUS_ABORTED);
                }
                this.reports.add(report);
                continue;
            }
            try {
                start = System.currentTimeMillis();
                this.helper.removeResource(this.resource, epr);
                end = System.currentTimeMillis();
                report.setResult(XMLReport.STATUS_OK);
                report.setError(XMLReport.NOT_AVAILABLE);
                end = System.currentTimeMillis();
                report.setExecutionTime(new Double((double)(end - start) / 1000.0));
            }
            catch (Exception e) {
                end = System.currentTimeMillis();
                report.setExecutionTime(new Double((double)(end - start) / 1000.0));
                report.setResult(XMLReport.STATUS_ERROR);
                report.setError(e.getMessage());
            }
            finally {
                this.reports.add(report);
            }
        }
    }
}

