/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.sam.istester.plugin.helpers;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ISCollectorHelper {
    static GCUBELog logger = new GCUBELog(ISCollectorHelper.class);
    private static Map<String, String> queryMap = null;

    protected static void loadQueries() {
        if (queryMap == null) {
            queryMap = new HashMap<String, String>();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = null;
                Document domDocument = null;
                builder = factory.newDocumentBuilder();
                domDocument = builder.parse(ISCollectorHelper.class.getResourceAsStream("QueryTemplates.xml"));
                Element root = domDocument.getDocumentElement();
                NodeList nodeList = root.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node == null) continue;
                    String query = node.getTextContent().trim();
                    String key = node.getNodeName();
                    queryMap.put(key, query);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not load query templates", (Throwable)e);
            }
        }
    }

    private static Map<String, String> getQueryMap() {
        ISCollectorHelper.loadQueries();
        return queryMap;
    }

    public static String prepareQuery(String type) {
        String template = ISCollectorHelper.getQueryMap().get(type);
        if (type.contains("SIMPLE_QUERY")) {
            return template.replace("***NAME***", GHNContext.getContext().getHostnameAndPort());
        }
        return template;
    }
}

