/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.personalization.userprofileaccess.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SMSUtils {
    private static final String serviceName = "UserProfileAccess";
    private static final String serviceClass = "Personalisation";
    private static final String directory = "/userprofiles/";
    static GCUBELog logger = new GCUBELog(SMSUtils.class);

    protected static String createDocument(String documentName, String payload) throws GCUBEFault {
        try {
            logger.debug((Object)"Trying to create a new document in SMS.....");
            logger.debug((Object)("NAME --> " + documentName));
            logger.debug((Object)("payload --> " + payload));
            ByteArrayInputStream is = new ByteArrayInputStream(payload.getBytes());
            IClient client = new StorageClient(serviceClass, serviceName, serviceName, AccessType.SHARED).getClient();
            String documentID = client.put(true).LFile((InputStream)is).RFile(directory + documentName + ".xml");
            return documentID;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to create a new document with name " + documentName), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to create a new document with name " + documentName});
        }
    }

    protected static String getDocument(String documentName) throws GCUBEFault {
        String content = null;
        try {
            IClient client = new StorageClient(serviceClass, serviceName, serviceName, AccessType.SHARED).getClient();
            InputStream in = client.get().RFileAsInputStream(directory + documentName + ".xml");
            content = IOUtils.toString((InputStream)in, (String)"UTF-8");
            if (content == null) {
                logger.error((Object)("document --> " + documentName + " does not exist."));
                throw new GCUBEUnrecoverableException("Document does not exist.");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the profile. an exception was thrown", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to get the profile. An exception was trhown"});
        }
        return content;
    }

    protected static void updateDocument(String documentName, String newContent) throws GCUBEFault {
        try {
            logger.debug((Object)("Trying to update document --> " + documentName));
            logger.debug((Object)("New content to be set is --> " + newContent));
            ByteArrayInputStream is = new ByteArrayInputStream(newContent.getBytes());
            IClient client = new StorageClient(serviceClass, serviceName, serviceName, AccessType.SHARED).getClient();
            client.put(true).LFile((InputStream)is).RFile(directory + documentName + ".xml");
            logger.debug((Object)"Document has been updated!");
        }
        catch (Exception e) {
            logger.error((Object)("Failed to update the document --> " + documentName + ". An exception was thrown"), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to update the document --> " + documentName + ". An exception was thrown"});
        }
    }

    protected static Document parseXMLFileToDOM(String XMLdoc) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(XMLdoc)));
        return doc;
    }

    protected static String createStringFromDomTree(Node tree) throws TransformerException {
        String nodeString = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(tree);
        transformer.transform(source, result);
        nodeString = sw.getBuffer().toString();
        return nodeString;
    }
}

