/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.personalization.userprofileaccess.impl;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.personalization.userprofileaccess.impl.SMSUtils;
import org.gcube.personalization.userprofileaccess.impl.StatefulContext;
import org.gcube.personalization.userprofileaccess.impl.UserProfileAccessResource;
import org.gcube.personalization.userprofileaccess.stubs.GetElementResponse;
import org.gcube.personalization.userprofileaccess.stubs.SetElement;
import org.gcube.personalization.userprofileaccess.stubs.SetElementValue;
import org.globus.wsrf.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UserProfileAccessService {
    static GCUBELog logger = new GCUBELog(UserProfileAccessService.class);
    static ISClient client = null;

    private UserProfileAccessResource getResource() throws ResourceException {
        return (UserProfileAccessResource)StatefulContext.getPortTypeContext().getWSHome().find();
    }

    public UserProfileAccessService() throws GCUBEFault {
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            throw new GCUBERetrySameFault(new String[]{"Failes to call the IS client"});
        }
    }

    private String getProfile() throws GCUBEFault {
        UserProfileAccessResource resource;
        try {
            resource = this.getResource();
        }
        catch (ResourceException e1) {
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to retrieve the Resource."});
        }
        try {
            String documentName = ((GCUBEWSResourceKey)resource.getID()).getValue();
            logger.debug((Object)("Inside the getProfile method. The document to be requested is --> " + documentName));
            return SMSUtils.getDocument(documentName);
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to instantiate a reader and retrieve the document"});
        }
    }

    public String getUserProfile(VOID params) throws GCUBEFault {
        return this.getProfile();
    }

    public String getElementValue(String elementName) throws GCUBEFault {
        String value = null;
        String userProfile = this.getUserProfile(new VOID());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(userProfile)));
            XPath xpath = XPathFactory.newInstance().newXPath();
            value = (String)xpath.evaluate(elementName + "/text()", document, XPathConstants.STRING);
            logger.info((Object)("The value of the element <<" + elementName + ">> is: <<" + value + ">>"));
        }
        catch (Exception e) {
            logger.error((Object)"Element not found. Failed to get the requested element of the profile.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Element not found. Failed to get the requested element of the profile."});
        }
        return value;
    }

    public VOID setElementValue(SetElementValue params) throws GCUBEFault {
        UserProfileAccessResource resource;
        try {
            resource = this.getResource();
        }
        catch (ResourceException e1) {
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to retrieve the WS-Resource."});
        }
        String userProfile = this.getProfile();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(userProfile)));
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                Node node = (Node)xpath.evaluate(params.getElementName(), document, XPathConstants.NODE);
                node.setTextContent(params.getValue());
            }
            catch (Exception e) {
                logger.error((Object)("Element: " + params.getElementName() + "not found. Failed to set the value at the profile."), (Throwable)e);
                throw new GCUBEUnrecoverableFault(new String[]{"Element not found. Failed to set the value at the profile."});
            }
            logger.info((Object)("Element: " + params.getElementName() + "updated with the value: " + params.getValue()));
            String nodeString = SMSUtils.createStringFromDomTree(document);
            SMSUtils.updateDocument(((GCUBEWSResourceKey)resource.getID()).getValue(), nodeString);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update the profile.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to update the profile."});
        }
        return new VOID();
    }

    public GetElementResponse getElement(String elementName) throws GCUBEFault {
        String[] elNodes = null;
        String userProfile = this.getUserProfile(new VOID());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(userProfile)));
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nList = (NodeList)xpath.evaluate(elementName, document, XPathConstants.NODESET);
            if (nList != null) {
                elNodes = new String[nList.getLength()];
                for (int i = 0; i < elNodes.length; ++i) {
                    elNodes[i] = SMSUtils.createStringFromDomTree(nList.item(i));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Element not found.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Element not found."});
        }
        GetElementResponse ret = new GetElementResponse();
        ret.setElNodes(elNodes);
        return ret;
    }

    public VOID setElement(SetElement params) throws GCUBEFault {
        UserProfileAccessResource resource;
        try {
            resource = this.getResource();
        }
        catch (ResourceException e1) {
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to retrieve the WS-Resource."});
        }
        String userProfile = this.getProfile();
        try {
            Node node;
            Document document = SMSUtils.parseXMLFileToDOM(userProfile);
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                node = (Node)xpath.evaluate(params.getPath(), document, XPathConstants.NODE);
            }
            catch (Exception e) {
                logger.error((Object)"Element not found. Failed to set the new element under it.", (Throwable)e);
                throw new GCUBEUnrecoverableFault(new String[]{"Element not found. Failed to set the new element under it."});
            }
            Element el = document.createElement(params.getElementName());
            el.setTextContent(params.getValue());
            node.appendChild(el);
            logger.info((Object)("(Username: " + resource.getUsername() + ") A new element with name: '" + params.getElementName() + "' created under: '" + params.getPath() + "' in the user's profile."));
            String nodeString = SMSUtils.createStringFromDomTree(document);
            SMSUtils.updateDocument(((GCUBEWSResourceKey)resource.getID()).getValue(), nodeString);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update the profile.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to update the profile."});
        }
        return new VOID();
    }

    public VOID deleteElement(String elementName) throws GCUBEFault {
        UserProfileAccessResource resource;
        try {
            resource = this.getResource();
        }
        catch (ResourceException e1) {
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to retrieve the WS-Resource."});
        }
        String userProfile = this.getProfile();
        try {
            NodeList nodes;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(userProfile)));
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                nodes = (NodeList)xpath.evaluate(elementName, document, XPathConstants.NODESET);
            }
            catch (Exception e) {
                logger.error((Object)"Element not found", (Throwable)e);
                throw new GCUBEUnrecoverableFault(new String[]{"Element not found."});
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Node parentNode = node.getParentNode();
                if (parentNode == null) continue;
                parentNode.removeChild(node);
            }
            String nodeString = SMSUtils.createStringFromDomTree(document);
            try {
                SMSUtils.updateDocument(((GCUBEWSResourceKey)resource.getID()).getValue(), nodeString);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to update the profile, without the deleted elements.", (Throwable)e);
                throw new GCUBERetrySameFault(new String[]{"Failed to update the profile, without the deleted elements."});
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to delete the elements from the profile.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to delete the elements from the profile."});
        }
        return new VOID();
    }

    public VOID updateUserProfile(String profileContent) throws GCUBEFault {
        UserProfileAccessResource resource;
        try {
            resource = this.getResource();
        }
        catch (ResourceException e1) {
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to retrieve the Resource."});
        }
        try {
            SMSUtils.updateDocument(((GCUBEWSResourceKey)resource.getID()).getValue(), profileContent);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update the user's profile", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to update the user's profile"});
        }
        return new VOID();
    }
}

