package org.gcube.personalization.userprofileaccess.impl;

import java.io.StringReader;


import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.personalization.userprofileaccess.stubs.GetElementResponse;
import org.gcube.personalization.userprofileaccess.stubs.SetElement;
import org.gcube.personalization.userprofileaccess.stubs.SetElementValue;
import org.globus.wsrf.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/**
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserProfileAccessService {

	static GCUBELog logger = new GCUBELog(UserProfileAccessService.class);
	static ISClient client = null;

	/**
	 * 
	 * @return the stateful resource
	 * @throws ResourceException if no resource was found in the current context
	 */
	private UserProfileAccessResource getResource() throws ResourceException {
		return (UserProfileAccessResource) StatefulContext.getPortTypeContext().getWSHome().find();
	}  

	/**
	 * The constructor of the class.
	 * 
	 * @throws GCUBEFault Failed to contact the IS client
	 */
	public UserProfileAccessService() throws GCUBEFault {
		try {
			client =GHNContext.getImplementation(ISClient.class);
		} catch (Exception e) {
			throw new GCUBERetrySameFault("Failes to call the IS client");
		}
	}

	/**
	 * This method returns a string which contains the user's profile.
	 *  
	 * @return a string representation of the profile
	 * @throws GCUBEFault an error occurred
	 */
	private String getProfile() throws GCUBEFault{
		UserProfileAccessResource resource;
		try {
			resource = this.getResource();
		} catch (ResourceException e1) {
			throw new GCUBEUnrecoverableFault("Failed to retrieve the Resource.");
		}
		try {
			String documentName = resource.getID().getValue();
			logger.debug("Inside the getProfile method. The document to be requested is --> " + documentName);
			return SMSUtils.getDocument(documentName);
		} catch (Exception e) {
			throw new GCUBEUnrecoverableFault("Failed to instantiate a reader and retrieve the document");
		} 	
	}


	/*************************************************************************************************************************************
	 * 													PUBLIC METHODS
	 *************************************************************************************************************************************/

	/**
	 * This method returns the user profile.
	 * 
	 * @param params This method has no input parameters
	 * @return A string which contains the user's profile
	 * @throws GCUBEFault an error occurred
	 */ 
	public String getUserProfile(VOID params) throws GCUBEFault{
		return (getProfile());
	}

	/**
	 * This method retrieves the value of a specific element of the user's profile.
	 * If the element does not exist in the profile it returns null.
	 * 
	 * @param elementName It is a XPath expression
	 * @return The value of the element
	 * @throws GCUBEFault an error occurred
	 */
	public String getElementValue(String elementName) throws GCUBEFault{
		String value = null;

		/* Get the XML document with the user profile */
		String userProfile = this.getUserProfile(new VOID());

		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(new InputSource(new StringReader(userProfile)));
			XPath xpath = XPathFactory.newInstance().newXPath();	 
			value = (String) xpath.evaluate(elementName+"/text()", document, XPathConstants.STRING);
			logger.info("The value of the element <<" + elementName + ">> is: <<" + value + ">>");
		}
		catch(Exception e) {
			logger.error("Element not found. Failed to get the requested element of the profile.", e);
			throw new GCUBEUnrecoverableFault("Element not found. Failed to get the requested element of the profile.");
		} 

		return value;
	}

	/**
	 * This method sets a new value to an element of the user's profile.
	 * If the element has already a value, it replaces it.
	 * 
	 * @param params: elementName,is a XPath expression
	 * 				  value, the value to be set
	 * @return no Return type
	 * @throws GCUBEFault an error occurred 
	 */
	public VOID setElementValue(SetElementValue params) throws  GCUBEFault{
		UserProfileAccessResource resource;
		try {
			resource = this.getResource();
		} catch (ResourceException e1) {
			throw new GCUBEUnrecoverableFault("Failed to retrieve the WS-Resource.");
		}

		String userProfile = getProfile();

		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(new InputSource(new StringReader(userProfile)));

			XPath xpath = XPathFactory.newInstance().newXPath();
			try {
				// Retrieve the element
				Node node = (Node)xpath.evaluate(params.getElementName(), document, XPathConstants.NODE);
				// set the new value
				node.setTextContent(params.getValue());
			}
			catch (Exception e) {
				logger.error("Element: " + params.getElementName() + "not found. Failed to set the value at the profile.", e);
				throw new GCUBEUnrecoverableFault("Element not found. Failed to set the value at the profile.");
			}
			logger.info("Element: " + params.getElementName() + "updated with the value: " + params.getValue());
			// Transform profile to a Stirng from a  DOM tree
			String nodeString = SMSUtils.createStringFromDomTree(document);
			//DocumentWriter writer = CMSUtils.getDocumentWriterByID(CMSUtils.getCollectionByName(UserProfileAccessFactoryService.userProfileCollectionName, ServiceContext.getContext().getScope()), ServiceContext.getContext().getScope());
			/* updates the content of the user profile */
			//CMSUtils.updateDocument(writer, resource.getUserProfileID(), nodeString, ServiceContext.getContext().getScope());
			SMSUtils.updateDocument(resource.getID().getValue(), nodeString);
		}
		catch(Exception e) {
			logger.error("Failed to update the profile.", e);
			throw new GCUBEUnrecoverableFault("Failed to update the profile.");
		} 
		return (new VOID());
	}

	/**
	 * This method retrieves an element of the user's profile.
	 * If there are many elements with the same name it returns an array which contains
	 * all these elements.
	 * 
	 * @param elementName It is a XPath expression
	 * @return the element(s)  as an XML node
	 * @throws GCUBEFault an error occurred
	 */
	public GetElementResponse getElement(String elementName) throws  GCUBEFault{
		String[] elNodes = null;

		/* Get the XML document with the user profile */
		String userProfile = this.getUserProfile(new VOID());
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(new InputSource(new StringReader(userProfile)));
			XPath xpath = XPathFactory.newInstance().newXPath();

			NodeList nList = (NodeList)xpath.evaluate(elementName, document, XPathConstants.NODESET);
			if (nList != null) {
				elNodes = new String[nList.getLength()];
				for(int i=0; i < elNodes.length; i++ ) {
					elNodes[i] = SMSUtils.createStringFromDomTree(nList.item(i));
				}
			}
		}
		catch(Exception e) {
			logger.error("Element not found.", e);
			throw new GCUBEUnrecoverableFault("Element not found.");
		} 
		GetElementResponse ret = new GetElementResponse();
		ret.setElNodes(elNodes);

		return ret;
	}

	/**
	 * This method creates a new element in the user's profile.
	 * The elementName and the path are XPath expressions.
	 * 
	 * @param params: elementName, the name of the new element 
	 * 				  value, the value of the new element
	 * 				  path, the path under it the new element will be set.
	 * 	
	 * @return no return type
	 * @throws GCUBEFault an error occurred
	 */
	public VOID setElement(SetElement params) throws GCUBEFault{
		UserProfileAccessResource resource;
		try {
			resource = getResource();
		} catch (ResourceException e1) {
			throw new GCUBEUnrecoverableFault("Failed to retrieve the WS-Resource.");
		}

		String userProfile = getProfile();

		try {
			Document document = SMSUtils.parseXMLFileToDOM(userProfile);

			XPath xpath = XPathFactory.newInstance().newXPath();

			/* TODO error check for the parameters. if the path is a node etc */
			Node node;
			try {
				node = (Node)xpath.evaluate(params.getPath(), document, XPathConstants.NODE);	        	
			}
			catch(Exception e) {
				logger.error("Element not found. Failed to set the new element under it.", e);
				throw new GCUBEUnrecoverableFault("Element not found. Failed to set the new element under it.");
			}


			/* creates a new element with the specified name and value
			 * and appends it with the specified node.
			 */
			Element el = document.createElement(params.getElementName());
			el.setTextContent(params.getValue());
			node.appendChild(el);
			logger.info("(Username: " + resource.getUsername() + ") A new element with name: '" + params.getElementName() + "' created under: '" + params.getPath() + "' in the user's profile.");

			/* Creates a string from the DOM tree */
			String nodeString = SMSUtils.createStringFromDomTree(document);
			//DocumentWriter writer = CMSUtils.getDocumentWriterByID(CMSUtils.getCollectionByName(UserProfileAccessFactoryService.userProfileCollectionName, ServiceContext.getContext().getScope()), ServiceContext.getContext().getScope());
			/* updates the content of the user profile */
			//CMSUtils.updateDocument(writer, resource.getUserProfileID(), nodeString, ServiceContext.getContext().getScope());
			SMSUtils.updateDocument(resource.getID().getValue(), nodeString);
		}
		catch(Exception e) {
			logger.error("Failed to update the profile.", e);
			throw new GCUBEUnrecoverableFault("Failed to update the profile.");
		} 
		return (new VOID());
	}

	/**
	 * This method deletes an element (or a set of elements) of the user's profile
	 * 
	 * @param elementName The element to delete. It is a XPath expression 
	 * @return no Return type
	 * @throws GCUBEFault an error occurred 
	 * 
	 */
	public VOID deleteElement(String elementName) throws GCUBEFault{
		UserProfileAccessResource resource;
		try {
			resource = getResource();
		} catch (ResourceException e1) {
			throw new GCUBEUnrecoverableFault("Failed to retrieve the WS-Resource.");
		}
		String userProfile = getProfile();

		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(new InputSource(new StringReader(userProfile)));
			XPath xpath = XPathFactory.newInstance().newXPath();

			NodeList nodes;
			try {
				nodes = (NodeList) xpath.evaluate(elementName, document, XPathConstants.NODESET);
			}
			catch (Exception e) {
				logger.error("Element not found", e);
				throw new GCUBEUnrecoverableFault("Element not found.");
			}
			for (int i=0; i<nodes.getLength(); i++) {
				Node node = nodes.item(i);
				Node parentNode = node.getParentNode();
				if (parentNode != null) {
					parentNode.removeChild(node);
				}
			}        
			/* Creates a string from the DOM tree */
			String nodeString = SMSUtils.createStringFromDomTree(document);

			try {
				//DocumentWriter writer = CMSUtils.getDocumentWriterByID(CMSUtils.getCollectionByName(UserProfileAccessFactoryService.userProfileCollectionName, ServiceContext.getContext().getScope()), ServiceContext.getContext().getScope());
				/* updates the content of the user profile */
				//CMSUtils.updateDocument(writer, resource.getUserProfileID(), nodeString, ServiceContext.getContext().getScope());
				SMSUtils.updateDocument(resource.getID().getValue(), nodeString);
			}
			catch(Exception e) {
				logger.error("Failed to update the profile, without the deleted elements.", e);
				throw new GCUBERetrySameFault("Failed to update the profile, without the deleted elements.");
			}
		}
		catch(Exception e) {
			logger.error("Failed to delete the elements from the profile.", e);
			throw new GCUBEUnrecoverableFault("Failed to delete the elements from the profile.");
		}	
		return new VOID();
	}

	public VOID updateUserProfile(String profileContent) throws GCUBEFault{
		UserProfileAccessResource resource;
		try {
			resource = this.getResource();
		} catch (ResourceException e1) {
			throw new GCUBEUnrecoverableFault("Failed to retrieve the Resource.");
		}
		//String documentID = null;
		try {
			//String collectionID = CMSUtils.getCollectionByName(UserProfileAccessFactoryService.userProfileCollectionName, ServiceContext.getContext().getScope());
		//	documentID = resource.getUserProfileID();
		//	logger.debug("Inside the getProfile method. The ID to be requested is --> " + documentID);
			//DocumentWriter writer = CMSUtils.getDocumentWriterByID(collectionID, ServiceContext.getContext().getScope());
			//CMSUtils.updateDocument(writer, documentID, profileContent, ServiceContext.getContext().getScope());
			SMSUtils.updateDocument(resource.getID().getValue(), profileContent);
		}catch(Exception e) {
			logger.error("Failed to update the user's profile", e);
			throw new GCUBEUnrecoverableFault("Failed to update the user's profile");
		}
		return new VOID();
	}

}
