package org.gcube.personalization.userprofileaccess.impl;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;

import javax.xml.namespace.QName;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.BaseNotificationConsumer;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.GCUBENotificationTopic;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.NotificationEvent;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

/**
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class ServiceContext extends GCUBEServiceContext{

	static GCUBELog logger = new GCUBELog(UserProfileAccessService.class);

	/**
	 * the jndi name
	 */
	public static final String JNDI_NAME="gcube/personalization/userprofileaccess";

	/** Single context instance, created eagerly */
	private static ServiceContext cache = new ServiceContext();

	/** 
	 * 
	 * @return cached instance
	 */
	public static ServiceContext getContext() {return cache;}

	/** Prevents accidental creation of more instances */
	private ServiceContext(){};


	/**
	 * {@inheritDoc}
	 */
	public String getJNDIName() {return JNDI_NAME;}

	/**
	 * {@inheritDoc}
	 */
	protected void onReady() {

//		try {
//			ISNotifier notifier = GHNContext.getImplementation(ISNotifier.class);
//			ArrayList<GCUBENotificationTopic> notTopics = new ArrayList<GCUBENotificationTopic>();
//			QName qName = new QName("http://gcube-system.org/namespaces/informationsystem/registry","GenericResource");
//			GCUBENotificationTopic notificationTopic = new GCUBENotificationTopic(qName);
//			notificationTopic.setPrecondition("/Profile/Name[starts-with(.,'" + "PresentationConfig-|-" + "')]" +
//				"or" + "/Profile/Name[starts-with(.,'" + "MetadataXSLT-|-" + "')]");
//			notTopics.add(notificationTopic);
//			// create a consumer for each scope of the RI
//			for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
//				XSLTNotificationConsumer con = new XSLTNotificationConsumer(scope);
//				//notifier.registerToISNotification(qnameList, con, ServiceContext.getContext(), scope);
//				notifier.registerToISNotification(con, notTopics, ServiceContext.getContext(), scope);
//				logger.debug("Registered to IS notification for Generic resources with scope: " + scope);
//			}
//		} catch (Exception e) {
//			logger.error("Could not register to Generic resource topic.", e);
//			e.printStackTrace();
//			return;
//		}
	}



	/**
	 * This class receives notifications when a generic resource is updated/deleted or when
	 * a new one is created. Depending on the type of the generic resource and if this kind of resource is added 
	 * to the profiles then it takes some actions in order to updated the existing profiles
	 * 
	 * @author Panagiota Koltsida, NKUA
	 *
	 */
//	private class XSLTNotificationConsumer extends BaseNotificationConsumer implements Runnable{
//
//		private static final String createOperation = "create";
//
//		private static final String updateOperation = "update";
//
//		private static final String deleteOperation = "destroy";
//
//		private GCUBEScope scope;
//
//		private LinkedBlockingQueue<String> newResourcesList = new LinkedBlockingQueue<String>();
//
//		private LinkedBlockingQueue<String> deletedResourcesList = new LinkedBlockingQueue<String>();
//		
//		Thread worker = new Thread(this);
//		
//		Object locker = new Object();
//
//		private static final long sleepCon = 2700000; //every 45 minutes
//
//		public XSLTNotificationConsumer(GCUBEScope scope) {
//			super();
//			this.scope = scope;
//			logger.debug("the worker thread will be started now. Working on resources for scope --> " + this.scope);
//			worker.start();
//		}
//
//		public void onNotificationReceived(NotificationEvent event) {
//			logger.debug("Notification is received...");
//
//			// Generic resource's ID
//			String id= event.getPayload().getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
//			String profile = null;
//			logger.debug("notification is received for the generic resource with ID --> " + id + " in scope --> " + this.scope);
//			// Operation that caused the notification. It could be "update", "destroy" or "create"
//			String operation=event.getPayload().getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
//			logger.debug("Generic resource's operation --> " + operation);
//			if (!operation.equals(deleteOperation)) {
//				profile=event.getPayload().getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
//				logger.debug("Generic resource's PROFILE -->  " + profile);
//			}
//			synchronized (this.locker) {
//				if (operation.equals(createOperation) || operation.equals(updateOperation)) {
//					// resource will be examined in order to be added to the profiles
//					if (!newResourcesList.contains(id)) {
//						newResourcesList.offer(id);
//						logger.debug("resource added to the creation list");
//					}
//					else
//						logger.debug("resource already exists in the creation list and it was not added");
//					
//				}
//				else if (operation.equals(deleteOperation)) {
//					// resource will be examined in order to be deleted from the profiles
//					// if the resource that is deleted had been added to the creation list and not yet examined then remove it from the list
//					if (newResourcesList.contains(id)) {
//						newResourcesList.remove(id);
//						logger.debug("resource removed from the creation list, since it is deleted before being examined");
//					}
//					
//					if (!deletedResourcesList.contains(id)){
//						deletedResourcesList.offer(id);
//						logger.debug("resource added to the deletion list");
//					}
//					else
//						logger.debug("resource already exists in the deletion list and it was not added");
//				}
//			}
//		}
//
//		public void run() {
//			while (true) {
//				//do what is needed in here for the profiles.
//				try {
//					// sleep for 5 minutes. Update the profiles every 5 minutes, depending on the received notifications
//					logger.debug("Start working on the list for deletions... (SCOPE --> " + this.scope + ")");
//					synchronized (this.locker) {
//						ArrayList<UserProfileAccessResource> profilesResources = UserProfilesUpdateIUtils.getRIsProfilesIDs(this.scope);
//						if (deletedResourcesList.isEmpty())
//							logger.debug("Deletion list is empty.");
//						else {
//							ArrayList<String> resourcesList = new ArrayList<String>();
//							while (!deletedResourcesList.isEmpty()) {
//								String id = deletedResourcesList.poll();
//								logger.info("resource that was deleted is --> " + id);
//								resourcesList.add(id);
//							}
//							try {
//								UserProfilesUpdateIUtils.removeGRReferencesFromProfiles(profilesResources, resourcesList, this.scope);
//							} catch (GCUBEFault e) {
//								logger.error("An exception was thrown", e);
//							}
//						}
//						logger.debug("Start working on the list for new Generic Resources... (SCOPE --> " + this.scope + ")");
//						if (newResourcesList.isEmpty()) {
//							logger.debug("List of new generic resources is empty.");
//						}
//						else {
//							ArrayList<String> resourcesList = new ArrayList<String>();
//							while (!newResourcesList.isEmpty()) {
//								String id = newResourcesList.poll();
//								logger.info("Generic resource that was created is --> "  + id);
//								resourcesList.add(id);
//							}
//							try {
//								UserProfilesUpdateIUtils.addNewXsltsToProfiles(profilesResources, resourcesList, this.scope);
//							} catch (GCUBEFault e) {
//								logger.error("An exception was thrown", e);
//							}
//						}
//					}
//					logger.debug("Going to sleep for " + sleepCon/60000 + " minutes....");
//					Thread.sleep(sleepCon);
//				} catch (InterruptedException e) {
//					logger.error("worker is interrupted");
//				}
//			}
//		}
//	}
}

