//package org.gcube.personalization.userprofileaccess.impl;
//
//import java.io.StringReader;
//import java.util.ArrayList;
//import java.util.Collection;
//import java.util.List;
//import java.util.Map;
//
//import javax.xml.parsers.DocumentBuilder;
//import javax.xml.parsers.DocumentBuilderFactory;
//import javax.xml.xpath.XPath;
//import javax.xml.xpath.XPathConstants;
//import javax.xml.xpath.XPathFactory;
//
//import org.gcube.common.core.faults.GCUBEFault;
//import org.gcube.common.core.faults.GCUBERetrySameFault;
//import org.gcube.common.core.informationsystem.client.AtomicCondition;
//import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
//import org.gcube.common.core.resources.GCUBEGenericResource;
//import org.gcube.common.core.scope.GCUBEScope;
//import org.gcube.common.core.state.GCUBEWSResource;
//import org.gcube.common.core.state.GCUBEWSResourceKey;
//import org.gcube.common.core.utils.logging.GCUBELog;
//import org.w3c.dom.Document;
//import org.w3c.dom.Element;
//import org.w3c.dom.Node;
//import org.w3c.dom.NodeList;
//import org.xml.sax.InputSource;
//
//public class UserProfilesUpdateIUtils {
//
//	static GCUBELog logger = new GCUBELog(UserProfileAccessService.class);
//	
//	private static final String delChars = "-|-";
//
//	/**
//	 * Gets the users' profiles ws resources that the current RI has created
//	 * 
//	 * @param scope The gCube scope to be used
//	 * @return ArrayList with the IDs
//	 */
//	protected static ArrayList<UserProfileAccessResource> getRIsProfilesIDs(GCUBEScope scope) {
//		logger.debug("Find the ws-resources of the current RI..... for scope --> " + scope);
//		ArrayList<UserProfileAccessResource> userProfilesResources = new ArrayList<UserProfileAccessResource>();
//		Collection<? extends GCUBEWSResourceKey> wsIDs = StatefulContext.getPortTypeContext().getWSHome().getIdentifiers();
//		logger.debug("The length of the wsIDs is --> " + wsIDs.size());
//			for (GCUBEWSResourceKey key : wsIDs) {
//				GCUBEWSResource resource;
//				try {
//					resource = StatefulContext.getPortTypeContext().getWSHome().find(key);
//					userProfilesResources.add((UserProfileAccessResource)resource);
//				} catch (Exception e) {
//					logger.error("Failed to get the ws-resources. " + e.getMessage(), e);
//				}	
//			}
//		return userProfilesResources;
//	}
//
//
//	/**
//	 * Removes all the references of the generic resources IDs from the RI's profiles, if they do exist. 
//	 * The profiles are then updated after the removal
//	 * 
//	 * @param profilesIDs The user profiles IDs
//	 * @param genericResourcesIDs The generic resources IDs
//	 * @param cms The content management service port type
//	 * @throws GCUBEFault
//	 */
//	protected static void removeGRReferencesFromProfiles(ArrayList<UserProfileAccessResource> profilesResources, ArrayList<String> genericResourcesIDs, GCUBEScope scope) throws GCUBEFault {
//		
//		// for each user profile
//		if (profilesResources != null && !profilesResources.isEmpty()) {
//			logger.debug("For each user profile ID check if any of the generic resources  should be removed from user's profile....");
//			for (UserProfileAccessResource profileResource : profilesResources) {
//				String newProfileContent;
//				String userProfileID = ((UserProfileAccessResource)profileResource).getUserProfileID();	
//	
//				try {					
//					String collectionID = CMSUtils.getCollectionByName(UserProfileAccessFactoryService.userProfileCollectionName, scope);
//					DocumentReader reader = CMSUtils.getDocumentReaderByID(collectionID, scope);
//					String profileContent = CMSUtils.getDocument(reader, userProfileID, scope);
//					// create the document of the profile
//					DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
//					DocumentBuilder builder = factory.newDocumentBuilder();
//					Document doc = builder.parse(new InputSource(new StringReader(profileContent)));
//					XPath xpath = XPathFactory.newInstance().newXPath();
//	
//					// for each generic resource
//					for (String grID : genericResourcesIDs) {
//						NodeList nodesToBeDeleted;
//						try {
//							nodesToBeDeleted = (NodeList) xpath.evaluate("/userprofile/preferences/xslts//xslt[id='" + grID + "']", doc, XPathConstants.NODESET);
//							for (int i=0; i<nodesToBeDeleted.getLength(); i++) {
//					        	Node node = nodesToBeDeleted.item(i);
//						        Node parentNode = node.getParentNode();
//						        if (parentNode != null) {
//						        	parentNode.removeChild(node);
//						        }
//					        }
//						}
//						catch (Exception e) {
//							logger.debug("Element not found in profile and won't be deleted", e);	
//						}	
//					}
//					newProfileContent = CMSUtils.createStringFromDomTree(doc);
//					
//					 try {
//						 /* updates the content of the user profile */
//						 	DocumentWriter writer = CMSUtils.getDocumentWriterByID(collectionID, scope);
//							CMSUtils.updateDocument(writer, userProfileID, newProfileContent, scope);
//				        }
//				        catch(Exception e) {
//				        	logger.error("Failed to update the profile with ID --> " + userProfileID + "  without the deleted elements.", e);
//							throw new GCUBERetrySameFault("Failed to update the profile, without the deleted elements.");
//				        }
//				} catch (Exception e) {
//					logger.error("Failed to get the profile with ID --> " + userProfileID, e);
//				}
//			}
//		}
//	}
//	
//	protected static void addNewXsltsToProfiles(ArrayList<UserProfileAccessResource> profilesResources, ArrayList<String> genericResourcesIDs, GCUBEScope scope) throws GCUBEFault {
//		// for each user profile
//		if (profilesResources != null && !profilesResources.isEmpty()) {
//			for (UserProfileAccessResource profileResource : profilesResources) {
//				String newProfileContent;
//				Boolean hasChanged = false;
//				String userProfileID = ((UserProfileAccessResource)profileResource).getUserProfileID();
//				logger.debug("Checking profile with ID --> " + userProfileID);
//				
//				try {
//					String collectionID = CMSUtils.getCollectionByName(UserProfileAccessFactoryService.userProfileCollectionName, scope);
//					DocumentReader reader = CMSUtils.getDocumentReaderByID(collectionID, scope);
//					String profileContent = CMSUtils.getDocument(reader, userProfileID, scope);
//					// create the document of the profile
//					DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
//					DocumentBuilder builder = factory.newDocumentBuilder();
//					Document doc = builder.parse(new InputSource(new StringReader(profileContent)));
//					XPath xpath = XPathFactory.newInstance().newXPath();
//	
//					// Get all scopes that this ws-resource belongs to
//					List<String> wsResourcesScopes = profileResource.getResourcePropertySet().getScope();
//					
//					// for each generic resource
//					for (String grID : genericResourcesIDs) {
//						
//						
//						try{
//							GCUBEGenericResourceQuery query = UserProfileAccessService.client.getQuery(GCUBEGenericResourceQuery.class);
//							query.addAtomicConditions(new AtomicCondition("/ID", grID));
//							List<GCUBEGenericResource> result = UserProfileAccessService.client.execute(query, scope);
//							if (result==null || result.size()==0)
//								throw new Exception("Generic resource not found.");
//							
//							// if one of the gr scopes is contained in any of the ws resource's scopes
//							Boolean hasCommonScope = false;
//							// Get all scopes that this generic resource belongs to
//							Map<String,GCUBEScope> GRscopes = result.get(0).getScopes();
//							for (String wsScope : wsResourcesScopes) {
//								if (GRscopes.containsKey(wsScope)) {
//									hasCommonScope = true;
//									logger.debug("Ws resource and generic resource have a common scope");
//									break;
//								}
//							}
//							
//							if (hasCommonScope) {
//							/* check the name of the generic resource. If it is a presentation or metadata XSLT then it should be added to
//							the profile if this schema does not exist in the profile. */
//							String resourceName = result.get(0).getName();
//							logger.debug("Working on the GR with ID --> " + grID + " and name --> " + resourceName);
//							String nameParts[] = resourceName.split("-\\|-");
//							if (nameParts.length > 0) {
//								// it is a Presentation config resource. Maybe it should be added to profile
//							/*	if (nameParts[0].equals(UserProfileAccessFactoryService.PresentationXSLT)) {
//									// check if an xslt for the schema exists in user's profile
//									NodeList nodes = null;
//									try {
//										nodes = (NodeList) xpath.evaluate("/userprofile/preferences/xslts/presentationxslt/xslt[name[starts-with(.,'" + nameParts[1] + "')]]", doc, XPathConstants.NODESET);
//									} catch (Exception e) {
//										logger.error("Failed to evaluate the expression.");
//									}
//									// there is already an xslt for this schema
//									if (nodes != null && nodes.getLength() > 0) {
//										// do nothing for that resource
//										logger.debug("A presentation xslt already exists for that schema. Not adding anything");
//									}
//									// add this new xslt to the user's profile
//									else {
//										logger.debug("This presentation XSLT refers to a new schema that does not exist in user's profile. It will be added");
//										Element pXslts = (Element) xpath.evaluate("/userprofile/preferences/xslts/presentationxslt", doc, XPathConstants.NODE);
//										Element xs = doc.createElement("xslt");
//										Element el = doc.createElement("name");
//										el.setTextContent(nameParts[1] + delChars + nameParts[2]); //schemaName-|-xsltName
//										Element el2 = doc.createElement("id");
//										el2.setTextContent(grID);
//										xs.appendChild(el);
//										xs.appendChild(el2);
//										pXslts.appendChild(xs);
//										hasChanged = true;
//									}
//								}*/
//								// It is a Metadata xslt resource. Maybe it should be added to profile
//								if (nameParts[0].equals(UserProfileAccessFactoryService.MetadataXSLT)) {
//									
//									// check if an xslt for the schema exists in user's profile
//									NodeList nodes = null;
//									try {
//										nodes = (NodeList) xpath.evaluate(
//												"/userprofile/preferences/xslts/metadataxslt/xslt[name[starts-with(.,'"
//														+ nameParts[1] + "')]]", doc,
//												XPathConstants.NODESET);
//									} catch (Exception e) {
//										logger.error("Failed to evaluate the expression.");
//									}
//									// there is already an xslt for this schema
//									if (nodes != null && nodes.getLength() > 0) {
//										// do nothing for that resource
//										logger.debug("A metadata xslt already exists for that schema. Not adding anything");
//									}
//									// add this new xslt to the user's profile
//									else {
//										logger.debug("This metadata XSLT refers to a new schema that does not exist in user's profile. It will be added");
//										Element mXslts = (Element) xpath.evaluate("/userprofile/preferences/xslts/metadataxslt", doc, XPathConstants.NODE);
//										Element xs = doc.createElement("xslt");
//										Element el = doc.createElement("name");
//										el.setTextContent(nameParts[1] + delChars + nameParts[2]); //schemaName-|-xsltName
//										Element el2 = doc.createElement("id");
//										el2.setTextContent(grID);
//										xs.appendChild(el);
//										xs.appendChild(el2);
//										mXslts.appendChild(xs);
//										hasChanged = true;
//									}	
//								}
//							}
//						}
//						else
//							logger.debug("The ws resource and the GR don't have a common scope. This resource won't be examined");
//								
//							
//						}catch (Exception e) {
//							logger.error("Error while trying to retrieve the generic resource with ID: " + grID,e);
//						}
//			
//					}
//					// if the profile has been updated at least for one resource then it should be also updated on the CMS
//					if (hasChanged) {
//						newProfileContent = CMSUtils.createStringFromDomTree(doc);
//						
//						 try {
//					        /* updates the content of the user profile */
//							 DocumentWriter writer = CMSUtils.getDocumentWriterByID(collectionID, scope);
//							CMSUtils.updateDocument(writer, userProfileID, newProfileContent, scope);
//					        }
//					        catch(Exception e) {
//					        	logger.error("Failed to update the profile, with the new elements.", e);
//								throw new GCUBERetrySameFault("Failed to update the profile with the new elements");
//					        }
//					}	
//				} catch (Exception e) {
//					logger.error("Failed to get the profile with ID --> " + profileResource, e);
//				}
//			}
//		}
//	}
//	
//	
//
//}