package org.gcube.personalization.userprofileaccess.client.library.stubs;

import static org.gcube.personalization.userprofileaccess.client.library.utils.UserProfileAccessCLConstants.*;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.Destroy;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.GetElementResponse;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.SetElement;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.SetElementValue;
import org.gcube.personalization.userprofileaccess.client.library.exceptions.UserProfileAccessException;

@WebService(name = porttypeLN, targetNamespace = porttypeNS)
public interface UserProfileAccessStub {
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	String getUserProfile(Empty empty);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	String getElementValue(String elementName);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	void setElementValue(SetElementValue params);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	GetElementResponse getElement(String elementName);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	void setElement(SetElement params) throws UserProfileAccessException;
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	void deleteElement(String elementName);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	void updateUserProfile(String profileContent);

	@WebMethod(operationName = "Destroy")
	@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
	public void destroy(@WebParam(name = "Destroy", targetNamespace = "http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd") Destroy destroy);
	
}
