package org.gcube.personalization.profileadministration.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.personalization.profileadministration.client.library.beans.Types.ValidateProfile;
import org.gcube.personalization.profileadministration.client.library.exceptions.ProfileAdministrationException;
import org.gcube.personalization.profileadministration.client.library.stubs.ProfileAdministrationStub;

public class ProfileAdministrationCLDefaultProxy implements ProfileAdministrationCLProxyI {
	
	private final ProxyDelegate<ProfileAdministrationStub> delegate;
	
	public ProfileAdministrationCLDefaultProxy(ProxyDelegate<ProfileAdministrationStub> config) {
		this.delegate = config;
	}

	@Override
	public void setDefaultProfile(final String profile) throws ProfileAdministrationException {
		Call<ProfileAdministrationStub, Empty> call = new Call<ProfileAdministrationStub, Empty>() {
			@Override
			public Empty call(ProfileAdministrationStub endpoint) throws Exception {
				endpoint.setDefaultProfile(profile);
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new ProfileAdministrationException(e);
		}
	}

	@Override
	public void createUserProfile(final String username) throws ProfileAdministrationException {
		Call<ProfileAdministrationStub, Empty> call = new Call<ProfileAdministrationStub, Empty>() {
			@Override
			public Empty call(ProfileAdministrationStub endpoint) throws Exception {
				endpoint.createUserProfile(username);
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new ProfileAdministrationException(e);
		}
	}

	@Override
	public void dropUserProfile(final String username) throws ProfileAdministrationException {
		Call<ProfileAdministrationStub, Empty> call = new Call<ProfileAdministrationStub, Empty>() {
			@Override
			public Empty call(ProfileAdministrationStub endpoint) throws Exception {
				endpoint.dropUserProfile(username);
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new ProfileAdministrationException(e);
		}
		
	}

	@Override
	public void validateProfile(final ValidateProfile params) throws ProfileAdministrationException {
		Call<ProfileAdministrationStub, Empty> call = new Call<ProfileAdministrationStub, Empty>() {
			@Override
			public Empty call(ProfileAdministrationStub endpoint) throws Exception {
				endpoint.validateProfile(params);
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new ProfileAdministrationException(e);
		}
	}

	
	
}
