/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.rmi.RemoteException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.opensearch.opensearchdatasource.service.OpenSearchOperator;
import org.gcube.opensearch.opensearchdatasource.service.OpenSearchService;
import org.gcube.opensearch.opensearchdatasource.service.ServiceContext;
import org.gcube.rest.commons.filter.IResourceFilter;
import org.gcube.rest.commons.helpers.JSONConverter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.gcube.rest.opensearch.common.apis.OpenSearchServiceAPI;
import org.gcube.rest.opensearch.common.discover.OpenSearchDiscovererAPI;
import org.gcube.rest.opensearch.common.helpers.ResultReader;
import org.gcube.rest.opensearch.common.resources.OpenSearchDataSourceResource;
import org.gcube.rest.resourceawareservice.ResourceAwareService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceAwareServiceException;
import org.gcube.rest.resourceawareservice.exceptions.ResourceNotFoundException;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.jboss.resteasy.annotations.GZIP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Singleton
public class OpenSearchService
extends ResourceAwareService<OpenSearchDataSourceResource>
implements OpenSearchServiceAPI {
    static final Logger logger = LoggerFactory.getLogger(OpenSearchService.class);
    private final OpenSearchOperator operator;
    private String scope;

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public String getResourceClass() {
        return "OpenSearchDataSourceResources";
    }

    public String getResourceNamePref() {
        return "OpenSearchDataSourceResource";
    }

    @Inject
    public OpenSearchService(ResourceFactory<OpenSearchDataSourceResource> factory, ResourcePublisher<OpenSearchDataSourceResource> publisher, IResourceFilter<OpenSearchDataSourceResource> resourceFilter, IResourceFileUtils<OpenSearchDataSourceResource> resourceFileUtils, OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer, OpenSearchOperator operator) throws ResourceAwareServiceException {
        super(factory, publisher, resourceFilter, resourceFileUtils);
        ServiceContext context = new ServiceContext(operator, discoverer);
        context.initialize();
        this.operator = operator;
    }

    @GET
    @Path(value="/{id}/query")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response query(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="queryString") String queryString, @DefaultValue(value="true") @QueryParam(value="useRR") Boolean useRR, @DefaultValue(value="false") @QueryParam(value="result") Boolean result, @DefaultValue(value="false") @QueryParam(value="stream") Boolean stream, @DefaultValue(value="false") @QueryParam(value="pretty") Boolean pretty) {
        logger.info("will execute query for query : " + queryString);
        String msg = null;
        Response.Status status = null;
        OpenSearchDataSourceResource resource = null;
        try {
            resource = (OpenSearchDataSourceResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        URI grslocatorURI = null;
        try {
            grslocatorURI = this.operator.query(resource, queryString, useRR.booleanValue());
            String grslocator = grslocatorURI.toASCIIString();
            if (result.booleanValue()) {
                if (stream.booleanValue()) {
                    1 stm = new /* Unavailable Anonymous Inner Class!! */;
                    msg = stm;
                    status = Response.Status.OK;
                } else {
                    msg = ResultReader.resultSetToJsonRecords((String)grslocator, (boolean)pretty);
                    status = Response.Status.OK;
                }
            } else {
                msg = JSONConverter.convertToJSON((String)"grslocator", (Object)grslocator);
                status = Response.Status.OK;
            }
        }
        catch (RemoteException e) {
            logger.error("error while querying for query : " + queryString, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("error while querying : " + e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }
}

