/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.faults.GCUBERetrySameException;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceResource;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceResourceHome;
import org.gcube.opensearch.opensearchdatasource.ServiceContext;
import org.gcube.opensearch.opensearchdatasource.StatefulContext;
import org.gcube.opensearch.opensearchdatasource.stubs.CreateResourceParams;
import org.gcube.opensearch.opensearchdatasource.stubs.CreateResourceResponse;
import org.gcube.opensearch.opensearchdatasource.stubs.Provider;
import org.globus.wsrf.ResourceKey;

public class OpenSearchDataSourceFactory
extends GCUBEPortType {
    GCUBELog logger = new GCUBELog(OpenSearchDataSourceFactory.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private static final int ISRETRY = 3;

    public CreateResourceResponse createResource(CreateResourceParams request) throws GCUBEFault {
        try {
            this.logger.debug((Object)("CreateResource called... with params: " + request.getProviders() + ", " + request.getFields()));
            CreateResourceResponse response = this.create(request.getFields().getArray(), request.getProviders() != null ? request.getProviders() : new Provider[]{}, request.getResourceKey());
            return response;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to create lookup resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[]{"*** In OpenSearchDataSource.createResource ***"});
        }
    }

    private CreateResourceResponse create(String[] fields, Provider[] providers, String resourceKey) throws RemoteException {
        OpenSearchDataSourceResource resource = null;
        CreateResourceResponse response = new CreateResourceResponse();
        String[] collectionIDs = new String[providers.length];
        String[] openSearchResourceIDs = new String[providers.length];
        String[][] fixedParameters = new String[providers.length][];
        for (int i = 0; i < providers.length; ++i) {
            collectionIDs[i] = providers[i].getCollectionID();
            openSearchResourceIDs[i] = providers[i].getOpenSearchResourceID();
            fixedParameters[i] = providers[i].getFixedParameters().getArray() != null ? providers[i].getFixedParameters().getArray() : new String[]{};
        }
        if (resourceKey != null) {
            try {
                this.logger.debug((Object)("Adding providers to resource " + resourceKey));
                OpenSearchDataSourceResourceHome wsHome = (OpenSearchDataSourceResourceHome)StatefulContext.getPortTypeContext().getWSHome();
                resource = (OpenSearchDataSourceResource)wsHome.find((ResourceKey)new GCUBEWSResourceKey(new QName("resource"), resourceKey));
                resource.addProviders(fields, collectionIDs, openSearchResourceIDs, fixedParameters);
                resource.store();
                response.setEndpointReference(resource.getEPR());
                return response;
            }
            catch (Exception e) {
                throw new RemoteException("Could not add providers", e);
            }
        }
        XMLResult[] genericResources = new XMLResult[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            ISClient client = null;
            GCUBEGenericQuery query = null;
            try {
                client = (ISClient)GHNContext.getImplementation(ISClient.class);
                query = client.getQuery("GCUBEResourceQuery");
            }
            catch (Exception e) {
                throw new GCUBERetryEquivalentException("Could not get ISClient or GCUBEGenericQuery");
            }
            query.addParameters(new QueryParameter[]{new QueryParameter("FILTER", "$result/ID/string() eq '" + openSearchResourceIDs[i] + "'"), new QueryParameter("TYPE", "GenericResource"), new QueryParameter("RESULT", "$result/Profile/Body")});
            List res = null;
            for (int retryOnError = 0; retryOnError < 3; ++retryOnError) {
                try {
                    res = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
                    break;
                }
                catch (Exception e) {
                    this.logger.error((Object)"Could not retrieve generic resources. continuing");
                    continue;
                }
            }
            if (res == null || res.size() == 0) {
                throw new GCUBERetrySameException("The generic resource with ID: " + openSearchResourceIDs[i] + " was not found.");
            }
            if (res.size() > 1) {
                throw new GCUBERetrySameException("The generic resource with ID: " + openSearchResourceIDs[i] + " was found " + res.size() + " times published.");
            }
            genericResources[i] = (XMLResult)res.get(0);
        }
        try {
            GCUBEStatefulPortTypeContext ptctx = StatefulContext.getPortTypeContext();
            GCUBEWSResourceKey key = ptctx.makeKey(uuidGen.nextUUID());
            resource = (OpenSearchDataSourceResource)ptctx.getWSHome().create(key, new Object[]{key, fields, collectionIDs, genericResources, openSearchResourceIDs, fixedParameters});
            response.setEndpointReference(resource.getEPR());
            resource.store();
        }
        catch (Exception e) {
            this.logger.error((Object)"*** Unable to create lookup resource ***", (Throwable)e);
            throw new GCUBERetrySameFault(new String[]{" *** Unable to create lookup resource *** " + e.getMessage()});
        }
        return response;
    }

    private List<EndpointReferenceType> getWSResourceEPRsFromPropValuesAndNamespace(List<String[]> properties, String namespace, GCUBEScope scope) throws Exception {
        String filter = "$result/child::*[local-name()='" + properties.get(0)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(0)[1].trim() + "'";
        for (int i = 1; i < properties.size(); ++i) {
            filter = filter + " and $result/child::*[local-name()='" + properties.get(i)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(i)[1].trim() + "'";
        }
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        gquery.addGenericCondition(filter);
        LinkedList<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
        for (RPDocument d : client.execute((ISQuery)gquery, scope)) {
            ret.add(d.getEndpoint());
        }
        return ret;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

