/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.opensearch.common.helpers;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.rest.commons.helpers.JSONConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultReader {
    private static final Logger logger = LoggerFactory.getLogger(ResultReader.class);

    public static List<Map<String, String>> resultSetToRecords(String grslocator) throws Exception {
        ArrayList<Map<String, String>> records = new ArrayList<Map<String, String>>();
        ForwardReader reader = new ForwardReader(new URI(grslocator));
        try {
            for (GenericRecord rec : reader) {
                HashMap<String, String> record = new HashMap<String, String>();
                for (Field field : rec.getFields()) {
                    String fieldName = field.getFieldDefinition().getName();
                    String value = ((StringField)field).getPayload();
                    logger.info("fieldName : " + fieldName);
                    logger.info("fieldValue : " + value);
                    record.put(fieldName, value);
                }
                records.add(record);
            }
            reader.close();
        }
        catch (Exception e) {
            logger.warn("error while reading results", (Throwable)e);
            reader.close();
            throw e;
        }
        return records;
    }

    public static String recordsToJson(List<Map<String, String>> records, boolean pretty) {
        return JSONConverter.convertToJSON(records, (boolean)pretty);
    }

    public static String resultSetToJsonRecords(String grslocator, boolean pretty) {
        List<Map<String, String>> records = null;
        try {
            records = ResultReader.resultSetToRecords(grslocator);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JSONConverter.convertToJSON((String)"error", (Object)("error while consuming grs2 : " + e.getMessage()));
        }
        return JSONConverter.convertToJSON(records, (boolean)pretty);
    }

    public static void streamResultSetToJsonRecords(Writer writer, String grslocator, boolean pretty) throws Exception {
        ForwardReader reader = new ForwardReader(new URI(grslocator));
        try {
            for (GenericRecord rec : reader) {
                HashMap<String, String> record = new HashMap<String, String>();
                for (Field field : rec.getFields()) {
                    String fieldName = field.getFieldDefinition().getName();
                    String value = ((StringField)field).getPayload();
                    record.put(fieldName, value);
                }
                String jsonRec = JSONConverter.convertToJSON(record, (boolean)pretty);
                writer.write(jsonRec);
            }
            reader.close();
        }
        catch (Exception e) {
            reader.close();
            throw e;
        }
    }
}

