/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.producer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class ActiveMQClient
implements Runnable {
    private static int ackMode;
    private static boolean transacted;
    private static ActiveMQClient singleton;
    private String selectorBase = "MessageType";
    private static Integer MAX_MONITORING_QUEUE_SIZE;
    private static Integer MAX_ACCOUNTING_QUEUE_SIZE;
    private static ConcurrentLinkedQueue<GCUBEMessage> messageForQueue;
    private static ConcurrentLinkedQueue<GCUBEMessage> messageForTopic;

    private ActiveMQClient() {
    }

    public void sendMessage(GCUBEMessage message, String ... selectorType) {
        ArrayList<TopicConnection> connections = GCUBELocalProducer.getTopicConnection(GCUBEScope.getScope((String)message.getScope()));
        if (connections != null) {
            for (TopicConnection connection : connections) {
                try {
                    TopicSession session = connection.createTopicSession(transacted, ackMode);
                    Topic topic = session.createTopic(message.getTopic());
                    TopicPublisher publisher = session.createPublisher(topic);
                    publisher.setDeliveryMode(2);
                    publisher.setTimeToLive(86400000L);
                    ObjectMessage objMsg = session.createObjectMessage();
                    objMsg.setObject((Serializable)message);
                    objMsg.setJMSMessageID(this.createRandomString());
                    if (selectorType.length != 0) {
                        objMsg.setStringProperty(this.selectorBase, selectorType[0]);
                    }
                    publisher.send((Message)objMsg);
                    GCUBELocalProducer.logger.debug((Object)("Message " + message.toString() + " SENT"));
                    return;
                }
                catch (JMSException e) {
                    GCUBELocalProducer.logger.error((Object)"Exception sending message to the Broker", (Throwable)e);
                    this.enqueueMessageForTopic(message);
                }
                catch (Exception e) {
                    GCUBELocalProducer.logger.error((Object)"Exception sending message to the Broker", (Throwable)e);
                    this.enqueueMessageForTopic(message);
                }
            }
        }
        GCUBELocalProducer.reloadConnection(GCUBEScope.getScope((String)message.getScope()));
    }

    public void sendMessageToQueue(GCUBEMessage message) {
        ArrayList<QueueConnection> connections = GCUBELocalProducer.getQueueConnection(GCUBEScope.getScope((String)message.getScope()));
        if (connections != null) {
            for (QueueConnection connection : connections) {
                try {
                    QueueSession session = connection.createQueueSession(transacted, ackMode);
                    Queue queue = session.createQueue(message.getTopic());
                    QueueSender sender = session.createSender(queue);
                    sender.setDeliveryMode(2);
                    ObjectMessage objMsg = session.createObjectMessage();
                    objMsg.setObject((Serializable)message);
                    objMsg.setJMSMessageID(this.createRandomString());
                    sender.send((Message)objMsg);
                    GCUBELocalProducer.logger.debug((Object)("Message " + message.toString() + " SENT"));
                    return;
                }
                catch (JMSException e) {
                    GCUBELocalProducer.logger.error((Object)"Exception sending message to the Broker", (Throwable)e);
                    this.enqueueMessageForQueue(message);
                }
                catch (Exception e) {
                    GCUBELocalProducer.logger.error((Object)"Exception sending message to the Broker", (Throwable)e);
                    this.enqueueMessageForQueue(message);
                }
            }
        }
        GCUBELocalProducer.reloadConnection(GCUBEScope.getScope((String)message.getScope()));
    }

    private String createRandomString() {
        Random random = new Random(System.currentTimeMillis());
        long randomLong = random.nextLong();
        return Long.toHexString(randomLong);
    }

    public static ActiveMQClient getSingleton() {
        return singleton;
    }

    public void setSingleton(ActiveMQClient singleton) {
        ActiveMQClient.singleton = singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessageForQueue(GCUBEMessage message) {
        try {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                if (messageForQueue.size() >= MAX_ACCOUNTING_QUEUE_SIZE) {
                    GCUBELocalProducer.logger.error((Object)"Reached Maximum queue size, message discarded");
                    GCUBELocalProducer.logger.error((Object)message.toString());
                } else {
                    messageForQueue.add(message);
                }
            }
        }
        catch (Exception e) {
            GCUBELocalProducer.logger.error((Object)("Error enqueuing GCUBEMessage : " + message.toString()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessageForTopic(GCUBEMessage message) {
        try {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForTopic;
            synchronized (concurrentLinkedQueue) {
                if (messageForTopic.size() >= MAX_MONITORING_QUEUE_SIZE) {
                    GCUBELocalProducer.logger.error((Object)"Reached Maximum queue size, message discarded");
                    GCUBELocalProducer.logger.error((Object)message.toString());
                } else {
                    messageForTopic.add(message);
                }
            }
        }
        catch (Exception e) {
            GCUBELocalProducer.logger.error((Object)("Error enqueuing GCUBEMessage : " + message.toString()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sizeQueue = 0;
        int sizeTopic = 0;
        while (true) {
            GCUBEMessage message;
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                sizeQueue = messageForQueue.size();
            }
            concurrentLinkedQueue = messageForTopic;
            synchronized (concurrentLinkedQueue) {
                sizeTopic = messageForTopic.size();
            }
            if (sizeQueue == 0 && sizeTopic == 0) {
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (sizeQueue > 0) {
                message = null;
                ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue2 = messageForQueue;
                synchronized (concurrentLinkedQueue2) {
                    message = messageForQueue.poll();
                }
                this.sendMessageToQueue(message);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (sizeTopic <= 0) continue;
            message = null;
            ConcurrentLinkedQueue<GCUBEMessage> e = messageForTopic;
            synchronized (e) {
                message = messageForTopic.poll();
            }
            this.sendMessage(message, new String[0]);
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        MAX_MONITORING_QUEUE_SIZE = 1000;
        MAX_ACCOUNTING_QUEUE_SIZE = 1000;
        messageForQueue = null;
        messageForTopic = null;
        ackMode = 1;
        transacted = false;
        singleton = new ActiveMQClient();
        messageForQueue = new ConcurrentLinkedQueue();
        messageForTopic = new ConcurrentLinkedQueue();
        Thread t = new Thread(singleton);
        t.start();
    }
}

