/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.nodeaccountingportlet.charts;

import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gchart.client.GChart;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.Window;
import org.gcube.messaging.accounting.nodeaccountingportlet.client.Costants;
import org.gcube.messaging.accounting.nodeaccountingportlet.client.GlobalInfo;

public class BarChart
extends GChart {
    final int WIDTH = 500;
    final int HEIGHT = 300;
    private String title;
    double maxRecords = 0.0;
    int maxRecordsCount = 0;
    private static int MAX_RECORDS = 30;

    public BarChart(String title, Record[] records) {
        this.title = title;
        this.setChartSize(500, 300);
        this.setChartTitle("<b><big>" + title + "</big><br>&nbsp;</b>");
        this.maxRecordsCount = this.getRecourdsCount(records);
        this.maxRecords = this.max(records);
        for (int iCurve = 0; iCurve < this.maxRecordsCount; ++iCurve) {
            this.addCurve();
            this.getCurve().getSymbol().setSymbolType(GChart.SymbolType.VBAR_SOUTHWEST);
            this.getCurve().getSymbol().setBackgroundColor(Costants.Colors.values()[iCurve % Costants.Colors.values().length].name());
            this.getCurve().setLegendLabel(records[iCurve].getAsString(records[iCurve].getFields()[2]));
            this.getCurve().getSymbol().setHovertextTemplate(GChart.formatAsHovertext((String)records[iCurve].getAsString(records[iCurve].getFields()[2])));
            this.getCurve().getSymbol().setModelWidth(1.0);
            this.getCurve().getSymbol().setBorderColor(Costants.Colors.black.name());
            this.getCurve().getSymbol().setBorderWidth(1);
            this.getCurve().addPoint((double)(iCurve + 1), records[iCurve].getAsDouble(GlobalInfo.get().getGraphIndex()));
        }
        this.getXAxis().addTick((double)this.maxRecordsCount / 2.0 + 1.0, GlobalInfo.get().getGraphTypeTitle());
        this.getXAxis().setTickLabelFontSize(20);
        this.getXAxis().setTickLabelThickness(40);
        this.getXAxis().setTickLength(6);
        this.getXAxis().setTickThickness(0);
        this.getXAxis().setAxisMin(0.0);
        this.getYAxis().setAxisMin(0.0);
        this.getYAxis().setAxisMax(this.maxRecords);
        this.getYAxis().setTickLabelFormat("####");
        if (this.maxRecords < 10.0) {
            this.getYAxis().setTickCount(2);
        }
        this.getYAxis().setHasGridlines(true);
    }

    public double max(Record[] t) {
        double maximum = t[0].getAsDouble(GlobalInfo.get().getGraphIndex());
        for (int i = 1; i < this.maxRecordsCount; ++i) {
            if (!(t[i].getAsDouble(GlobalInfo.get().getGraphIndex()) > maximum)) continue;
            maximum = t[i].getAsDouble(GlobalInfo.get().getGraphIndex());
        }
        return maximum;
    }

    private int getRecourdsCount(Record[] records) {
        System.out.println("Length: " + records.length);
        return records.length < MAX_RECORDS ? records.length : MAX_RECORDS;
    }

    public void showGraph() {
        Window window = new Window();
        window.setTitle(this.title);
        window.setClosable(true);
        window.setWidth(1000);
        window.setHeight(600);
        window.setPlain(true);
        window.add((Widget)this);
        window.setCloseAction(Window.CLOSE);
        this.update();
        window.show();
    }
}

