package org.gcube.messaging.monitoring.probes.ghn;

import java.util.Calendar;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.messaging.common.messages.Test;

/**
 * GHNProbe that checks Profile last Update
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class GHNLastUpdateProbe extends GHNProbe{

	/**
	 * Default Constructor
	 */
	public GHNLastUpdateProbe(){}
	/*
	 * (non-Javadoc)
	 * @see org.gcube.common.core.utils.handlers.GCUBEHandler#run()
	 */
	@Override
	public void run() throws Exception {
		Test test = new Test();
		try {	
			Calendar update = GHNContext.getContext().getGHN().getNodeDescription().getLastUpdate(); 
			test.setDescription("Check Last update performed on the GHNProfile");
			test.setType(Test.TestType.LAST_UPDATE);
			test.setTestNumber(Integer.valueOf(number++));
			test.setTestResult(update.getTimeInMillis());
			sendMessageWithTest(test);
		}catch (Exception e){
			logger.error("Error getting Last Update time",e);
		}  
	
	}

}

