/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.monitoring.probes.ghn;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBENotificationProbe;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.messaging.common.messages.GHNMessage;
import org.gcube.messaging.common.messages.Test;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.BrokerNotConfiguredInScopeException;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class GHNNotificationProbe
extends GCUBENotificationProbe {
    String ghnName = GHNContext.getContext().getHostnameAndPort();

    public void run() throws Exception {
        GHNConsumer ghnManager = new GHNConsumer(){

            protected void onGHNShutdown(Events.GHNLifeTimeEvent event) {
                GHNNotificationProbe.this.logger.debug((Object)"GHN shutdown event received");
                Test test = new Test();
                test.setDescription("GHN shutdown event received");
                test.setType(Test.TestType.NOTIFICATION);
                test.setPriority(Test.Priority.HIGH);
                GHNNotificationProbe.sendGHNTest(test);
                GHNContext.getContext().unsubscribeGHNEvents((GHNConsumer)this, new Events.GHNTopic[]{Events.GHNTopic.READY, Events.GHNTopic.SHUTDOWN});
            }

            protected void onGHNReady(Events.GHNLifeTimeEvent event) {
                GHNNotificationProbe.this.logger.debug((Object)"GHN Ready event received");
                Test test = new Test();
                test.setDescription("GHN Ready event received");
                test.setType(Test.TestType.NOTIFICATION);
                test.setPriority(Test.Priority.HIGH);
                GHNNotificationProbe.sendGHNTest(test);
            }
        };
        try {
            GHNContext.getContext().subscribeGHNEvents(ghnManager, new Events.GHNTopic[]{Events.GHNTopic.READY, Events.GHNTopic.SHUTDOWN});
            GHNContext.getContext().getGHN().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new GHNResourceConsumer(GHNContext.getContext().getHostnameAndPort()), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE, GCUBEResource.ResourceTopic.REMOVESCOPE});
        }
        catch (Exception e) {
            GCUBELocalProducer.logger.error((Object)"Error subscribing to Local events", (Throwable)e);
        }
    }

    public void sendMessage(GCUBEMessage message) {
        ActiveMQClient.getSingleton().sendMessage(message, new String[]{Test.TestType.NOTIFICATION.name()});
    }

    public static void sendGHNTest(Test test) {
        new GHNNotificationProbe().sendMessageWithTest(test);
    }

    public static void sendGHNTest(Test test, GCUBEScope scope) {
        new GHNNotificationProbe().sendMessageWithTest(test, scope);
    }

    public static GHNMessage createGHNMessage(GCUBEScope scope) {
        return new GHNMessage(GHNContext.getContext().getHostnameAndPort(), scope);
    }

    public void sendMessageWithTest(Test test) {
        for (GCUBEScope scope : GCUBELocalProducer.getMonitoredScope()) {
            GHNMessage message = new GHNMessage(this.ghnName, scope);
            message.setTest(test);
            message.setTimeNow();
            this.sendMessage((GCUBEMessage)message);
        }
    }

    public void sendMessageWithTest(Test test, GCUBEScope scope) {
        GHNMessage message = new GHNMessage(this.ghnName, scope);
        message.setTest(test);
        message.setTimeNow();
        this.sendMessage((GCUBEMessage)message);
    }

    private class GHNResourceConsumer
    extends GCUBEResource.ResourceConsumer {
        String ghnName;

        GHNResourceConsumer(String ghnName) {
            this.ghnName = ghnName;
        }

        protected void onAddScope(GCUBEResource.AddScopeEvent event) {
            for (GCUBEScope scope : (GCUBEScope[])event.getPayload()) {
                try {
                    GCUBELocalProducer.addScope((GCUBEScope)scope);
                }
                catch (BrokerNotConfiguredInScopeException e) {
                    GHNNotificationProbe.this.logger.error((Object)("Broker not configured for scope " + scope.toString()), (Throwable)e);
                }
                catch (GCUBEScopeNotSupportedException e) {
                    GHNNotificationProbe.this.logger.error((Object)"GCUBEScope not supported", (Throwable)e);
                }
                catch (Exception e) {
                    GHNNotificationProbe.this.logger.error((Object)"Exception adding scope", (Throwable)e);
                }
                GHNNotificationProbe.this.logger.debug((Object)("Added Scope " + scope.toString() + " to GHN"));
                Test test = new Test();
                test.setDescription("Added Scope " + scope.toString() + " to GHN");
                test.setType(Test.TestType.NOTIFICATION);
                test.setTestResult((Object)scope.toString());
                if (GCUBELocalProducer.checkStartScope((GCUBEScope)scope)) {
                    test.setPriority(Test.Priority.LOW);
                } else {
                    test.setPriority(Test.Priority.HIGH);
                }
                GHNNotificationProbe.sendGHNTest(test);
            }
        }

        protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
            for (GCUBEScope o : (GCUBEScope[])event.getPayload()) {
                GHNNotificationProbe.this.logger.debug((Object)("Removed Scope " + o.toString() + " from GHN"));
                Test test = new Test();
                test.setDescription("Removed Scope " + o.toString() + " from GHN");
                test.setType(Test.TestType.NOTIFICATION);
                test.setTestResult((Object)o.toString());
                test.setPriority(Test.Priority.HIGH);
                GHNNotificationProbe.sendGHNTest(test);
                GHNNotificationProbe.sendGHNTest(test, o);
                GCUBELocalProducer.removeScope((GCUBEScope)o);
            }
        }
    }
}

