/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.monitoring.probes.ri;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBENotificationProbe;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.RIMessage;
import org.gcube.messaging.common.messages.Test;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RINotificationProbe
extends GCUBENotificationProbe {
    public void run() throws Exception {
        GHNConsumer gHNConsumer = new GHNConsumer(){

            protected void onRIRegistration(Events.GHNRIRegistrationEvent gHNRIRegistrationEvent) {
                try {
                    ((GCUBEServiceContext)gHNRIRegistrationEvent.getPayload()).getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new RIResourceConsumer(((GCUBEServiceContext)gHNRIRegistrationEvent.getPayload()).getName(), ((GCUBEServiceContext)gHNRIRegistrationEvent.getPayload()).getServiceClass()), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE, GCUBEResource.ResourceTopic.REMOVESCOPE});
                }
                catch (Exception exception) {
                    GCUBELocalProducer.logger.error((Object)"Error sending message to broker", (Throwable)exception);
                }
            }
        };
        try {
            GHNContext.getContext().subscribeGHNEvents(gHNConsumer, new Events.GHNTopic[]{Events.GHNTopic.RIREGISTRATION});
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error Subscribing to GHN events", (Throwable)exception);
        }
    }

    public static void sendRIMessage(RIMessage rIMessage) {
        new RINotificationProbe().sendMessage((GCUBEMessage)rIMessage);
    }

    private static RIMessage<Test> createRIMessage(GCUBEScope gCUBEScope) {
        return new RIMessage(GHNContext.getContext().getHostnameAndPort(), gCUBEScope);
    }

    public void sendMessage(GCUBEMessage gCUBEMessage) {
        ActiveMQClient.getSingleton().sendMessage(gCUBEMessage, new String[]{Test.TestType.TEST.name()});
    }

    private class RIResourceConsumer
    extends GCUBEResource.ResourceConsumer {
        String serviceName;
        String serviceClass;

        RIResourceConsumer(String string, String string2) {
            this.serviceClass = string2;
            this.serviceName = string;
        }

        protected void onAddScope(GCUBEResource.AddScopeEvent addScopeEvent) {
            for (GCUBEScope gCUBEScope : (GCUBEScope[])addScopeEvent.getPayload()) {
                GCUBELocalProducer.logger.debug((Object)("Added Scope " + gCUBEScope.toString() + " to RI"));
                Test test = new Test();
                test.setDescription("Added Scope " + gCUBEScope.toString() + " to RI");
                test.setType(Test.TestType.NOTIFICATION);
                test.setTestResult((Object)gCUBEScope.toString());
                if (GCUBELocalProducer.checkStartScope((GCUBEScope)gCUBEScope)) {
                    test.setPriority(Test.Priority.LOW);
                } else {
                    test.setPriority(Test.Priority.HIGH);
                }
                try {
                    for (GCUBEScope gCUBEScope2 : GCUBELocalProducer.getMonitoredScope()) {
                        RIMessage rIMessage = RINotificationProbe.createRIMessage(gCUBEScope2);
                        rIMessage.setServiceName(this.serviceName);
                        rIMessage.setServiceClass(this.serviceClass);
                        rIMessage.setTest(test);
                        rIMessage.setTimeNow();
                        RINotificationProbe.sendRIMessage(rIMessage);
                    }
                }
                catch (Exception exception) {
                    RINotificationProbe.this.logger.error((Object)"Error sending message to broker", (Throwable)exception);
                }
            }
        }

        protected void onRemoveScope(GCUBEResource.RemoveScopeEvent removeScopeEvent) {
            for (GCUBEScope gCUBEScope : (GCUBEScope[])removeScopeEvent.getPayload()) {
                GCUBELocalProducer.logger.debug((Object)("Removed Scope " + gCUBEScope + "from RI"));
                Test test = new Test();
                test.setDescription("Removed Scope " + gCUBEScope + " from RI");
                test.setType(Test.TestType.NOTIFICATION);
                test.setTestResult((Object)gCUBEScope.toString());
                test.setPriority(Test.Priority.HIGH);
                try {
                    for (GCUBEScope gCUBEScope2 : GCUBELocalProducer.getMonitoredScope()) {
                        RIMessage rIMessage = RINotificationProbe.createRIMessage(gCUBEScope2);
                        rIMessage.setServiceName(this.serviceName);
                        rIMessage.setServiceClass(this.serviceClass);
                        rIMessage.setTest(test);
                        rIMessage.setTimeNow();
                        RINotificationProbe.sendRIMessage(rIMessage);
                    }
                    RIMessage rIMessage = RINotificationProbe.createRIMessage(gCUBEScope);
                    rIMessage.setServiceName(this.serviceName);
                    rIMessage.setServiceClass(this.serviceClass);
                    rIMessage.setTest(test);
                    rIMessage.setTimeNow();
                    RINotificationProbe.sendRIMessage(rIMessage);
                }
                catch (Exception exception) {
                    RINotificationProbe.this.logger.error((Object)"Error sending message to broker", (Throwable)exception);
                }
            }
        }
    }
}

