/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.monitoring.probes.ghn;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBENotificationProbe;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.messaging.common.messages.GHNMessage;
import org.gcube.messaging.common.messages.Test;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.BrokerNotConfiguredInScopeException;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class GHNNotificationProbe
extends GCUBENotificationProbe {
    String ghnName = GHNContext.getContext().getHostnameAndPort();

    public void run() throws Exception {
        GHNConsumer gHNConsumer = new GHNConsumer(){

            protected void onGHNShutdown(Events.GHNLifeTimeEvent gHNLifeTimeEvent) {
                GHNNotificationProbe.this.logger.debug((Object)"GHN shutdown event received");
                Test test = new Test();
                test.setDescription("GHN shutdown event received");
                test.setType(Test.TestType.NOTIFICATION);
                test.setPriority(Test.Priority.HIGH);
                GHNNotificationProbe.sendGHNTest(test);
                GHNContext.getContext().unsubscribeGHNEvents((GHNConsumer)this, new Events.GHNTopic[]{Events.GHNTopic.READY, Events.GHNTopic.SHUTDOWN});
            }

            protected void onGHNReady(Events.GHNLifeTimeEvent gHNLifeTimeEvent) {
                GHNNotificationProbe.this.logger.debug((Object)"GHN Ready event received");
                Test test = new Test();
                test.setDescription("GHN Ready event received");
                test.setType(Test.TestType.NOTIFICATION);
                test.setPriority(Test.Priority.HIGH);
                GHNNotificationProbe.sendGHNTest(test);
            }
        };
        try {
            GHNContext.getContext().subscribeGHNEvents(gHNConsumer, new Events.GHNTopic[]{Events.GHNTopic.READY, Events.GHNTopic.SHUTDOWN});
            GHNContext.getContext().getGHN().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new GHNResourceConsumer(GHNContext.getContext().getHostnameAndPort()), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE, GCUBEResource.ResourceTopic.REMOVESCOPE});
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.error((Object)"Error subscribing to Local events", (Throwable)exception);
        }
    }

    public void sendMessage(GCUBEMessage gCUBEMessage) {
        ActiveMQClient.getSingleton().sendMessage(gCUBEMessage, new String[]{Test.TestType.NOTIFICATION.name()});
    }

    public static void sendGHNTest(Test test) {
        new GHNNotificationProbe().sendMessageWithTest(test);
    }

    public static void sendGHNTest(Test test, GCUBEScope gCUBEScope) {
        new GHNNotificationProbe().sendMessageWithTest(test, gCUBEScope);
    }

    public static GHNMessage createGHNMessage(GCUBEScope gCUBEScope) {
        return new GHNMessage(GHNContext.getContext().getHostnameAndPort(), gCUBEScope);
    }

    public void sendMessageWithTest(Test test) {
        for (GCUBEScope gCUBEScope : GCUBELocalProducer.getMonitoredScope()) {
            GHNMessage gHNMessage = new GHNMessage(this.ghnName, gCUBEScope);
            gHNMessage.setTest(test);
            gHNMessage.setTimeNow();
            this.sendMessage((GCUBEMessage)gHNMessage);
        }
    }

    public void sendMessageWithTest(Test test, GCUBEScope gCUBEScope) {
        GHNMessage gHNMessage = new GHNMessage(this.ghnName, gCUBEScope);
        gHNMessage.setTest(test);
        gHNMessage.setTimeNow();
        this.sendMessage((GCUBEMessage)gHNMessage);
    }

    private class GHNResourceConsumer
    extends GCUBEResource.ResourceConsumer {
        String ghnName;

        GHNResourceConsumer(String string) {
            this.ghnName = string;
        }

        protected void onAddScope(GCUBEResource.AddScopeEvent addScopeEvent) {
            for (GCUBEScope gCUBEScope : (GCUBEScope[])addScopeEvent.getPayload()) {
                try {
                    GCUBELocalProducer.addScope((GCUBEScope)gCUBEScope);
                }
                catch (BrokerNotConfiguredInScopeException brokerNotConfiguredInScopeException) {
                    GHNNotificationProbe.this.logger.error((Object)("Broker not configured for scope " + gCUBEScope.toString()), (Throwable)brokerNotConfiguredInScopeException);
                }
                catch (GCUBEScopeNotSupportedException gCUBEScopeNotSupportedException) {
                    GHNNotificationProbe.this.logger.error((Object)"GCUBEScope not supported", (Throwable)gCUBEScopeNotSupportedException);
                }
                catch (Exception exception) {
                    GHNNotificationProbe.this.logger.error((Object)"Exception adding scope", (Throwable)exception);
                }
                GHNNotificationProbe.this.logger.debug((Object)("Added Scope " + gCUBEScope.toString() + " to GHN"));
                Test test = new Test();
                test.setDescription("Added Scope " + gCUBEScope.toString() + " to GHN");
                test.setType(Test.TestType.NOTIFICATION);
                test.setTestResult((Object)gCUBEScope.toString());
                if (GCUBELocalProducer.checkStartScope((GCUBEScope)gCUBEScope)) {
                    test.setPriority(Test.Priority.LOW);
                } else {
                    test.setPriority(Test.Priority.HIGH);
                }
                GHNNotificationProbe.sendGHNTest(test);
            }
        }

        protected void onRemoveScope(GCUBEResource.RemoveScopeEvent removeScopeEvent) {
            for (GCUBEScope gCUBEScope : (GCUBEScope[])removeScopeEvent.getPayload()) {
                GHNNotificationProbe.this.logger.debug((Object)("Removed Scope " + gCUBEScope.toString() + " from GHN"));
                Test test = new Test();
                test.setDescription("Removed Scope " + gCUBEScope.toString() + " from GHN");
                test.setType(Test.TestType.NOTIFICATION);
                test.setTestResult((Object)gCUBEScope.toString());
                test.setPriority(Test.Priority.HIGH);
                GHNNotificationProbe.sendGHNTest(test);
                GHNNotificationProbe.sendGHNTest(test, gCUBEScope);
                GCUBELocalProducer.removeScope((GCUBEScope)gCUBEScope);
            }
        }
    }
}

