/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.mail;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.mail.MailMessage;
import org.gcube.messaging.common.consumer.mail.MailRecipientHelper;
import org.gcube.messaging.common.consumer.mail.MailRecipientResource;
import org.gcube.messaging.common.consumer.mail.MailSummary;
import org.gcube.messaging.common.consumer.notifier.Notification;

public class MailClient {
    static final String subject = "gCube Monitoring";
    GCUBELog logger = new GCUBELog(MailClient.class);
    Map<String, MailRecipientHelper> scopeMap = Collections.synchronizedMap(new HashMap());
    String mailFile = null;
    MailRecipientHelper parser = null;
    boolean daylySummary = false;

    public void initialize() {
        this.daylySummary = (Boolean)ServiceContext.getContext().getProperty("MailSummary", new boolean[]{false});
        if (this.daylySummary) {
            final Calendar midnight = Calendar.getInstance();
            midnight.set(11, 23);
            midnight.set(12, 59);
            new Thread(){

                @Override
                public void run() {
                    block4: while (true) {
                        try {
                            while (true) {
                                Thread.sleep(20000L);
                                if (!Calendar.getInstance().before(midnight)) break;
                                try {
                                    Thread.sleep(1800000L);
                                    continue block4;
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                break;
                            }
                            new MailSummary().execute();
                            return;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    public void addScope(GCUBEScope scope) throws Exception {
        MailRecipientResource resource = new MailRecipientResource(scope);
        this.parser = new MailRecipientHelper();
        resource.setHandled(this.parser);
        GCUBEScheduledHandler scheduler = new GCUBEScheduledHandler();
        scheduler.setScheduled((GCUBEHandler)resource);
        scheduler.setInterval(3600L);
        scheduler.run();
        while (resource.getState().equals((Object)State.Running.INSTANCE)) {
            Thread.sleep(1000L);
        }
        this.scopeMap.put(scope.toString(), this.parser);
    }

    public Map<String, MailRecipientHelper> getScopeMap() {
        return this.scopeMap;
    }

    public void setScopeMap(Map<String, MailRecipientHelper> scopeMap) {
        this.scopeMap = scopeMap;
    }

    public void sendMailSummary(String message, String groupName) {
        new MailMessage(this.getSummaryMailForScope(groupName), message, subject).sendMail();
    }

    public void sendMailNotification(String message, Notification not, String groupName, String domain) {
        String subject = "gCube Monitoring - Type: " + not.getType() + " - GHN: " + not.getSourceGHN();
        new MailMessage(this.getNotificationMailForScopeAndDomain(groupName, domain), message, subject).sendMail();
    }

    public ArrayList<String> getNotificationMailForScopeAndDomain(String scope, String domain) {
        ArrayList<String> recipients = new ArrayList<String>();
        try {
            String query = "SELECT DISTINCT USER.email FROM USER INNER JOIN USERDOMAIN on USERDOMAIN.email=USER.email AND USERDOMAIN.Name='" + domain + "' " + "WHERE (USER.Admin=" + true + " OR USER.ReceiveNotification=" + true + ") AND USER.Scope='" + scope + "';";
            ResultSet result = ServiceContext.getContext().getMonitoringManager().query(query);
            while (result.next()) {
                recipients.add(result.getString("email"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving mail recipients ", (Throwable)e);
        }
        return recipients;
    }

    public ArrayList<String> getSummaryMailForScope(String scope) {
        ArrayList<String> recipients = new ArrayList<String>();
        try {
            String query = "SELECT DISTINCT USER.email FROM USER WHERE (USER.Admin=true OR USER.ReceiveSummary=true) AND USER.Scope='" + scope + "';";
            ResultSet result = ServiceContext.getContext().getMonitoringManager().query(query);
            while (result.next()) {
                recipients.add(result.getString("email"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving mail recipients ", (Throwable)e);
        }
        return recipients;
    }
}

